#' @keywords internal
Inv <- function(sigma, tol = sqrt(.Machine$double.eps)){
  # Calculate number of rows in sigma
  n <- nrow(sigma)

  if (n == 1){
    res <- 1/as.numeric(max(sigma, tol))
  } else {
    sp <- eigen(sigma)

    res <- sp$vector %*% diag(1/pmax(abs(sp$values), tol)) %*% t(sp$vector)
  }

  # Return res
  res
} # End Inv
