#' @keywords internal
objf <- function(coef, delta, order, d, r, sigma.init, eps, n, X, eps.delta){
  # The same function as Likelihood
  # Assign omega, alpha, beta, and pi coefficients values
  # Same question, should we do the same thing we did for GARCHX.select.default
  p <- order[1]
  q <- order[2]
  omega <- coef[1]
  alpha <- coef[2:(p+1)]
  
  if(q != 0){
    beta <- coef[(p+2):(p+q+1)]
  } else {
    beta <- 0
  }
  if(d != 0){
    pi <- coef[(p+q+2):(1+p+q+d)]
  } else {
    pi <- 0
  }
  # Initialize h
  h <- rep(0, n)
  h[1:(max(p,q))] <- sigma.init^{delta/2}


  for(t in (2+(max(p,q))-1):n)
  {
    if (d == 0)
      h[t] <- omega + alpha %*% eps.delta[(t-1):(t-p)] + beta %*% h[(t-1):(t-q)] 
    else
      h[t] <- omega + alpha %*% eps.delta[(t-1):(t-p)] + beta %*% h[(t-1):(t-q)] +  drop(X[t-1,] %*% pi)
    
  } # End for
  
  sigma <- h^(2/delta)

  qml <- mean(log(sigma[(r+1):n]) + eps[(r+1):n]^2/sigma[(r+1):n])

  qml
} # End objf
