% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_GARCHSK.R
\name{garchsk_est}
\alias{garchsk_est}
\title{This function estimates GARCHSK model's parameters.}
\usage{
garchsk_est(data)
}
\arguments{
\item{data}{vector time series data}
}
\value{
list of parameters,standard errors of parameters,t-statistics,the minimum value of log-likelihood,AIC and BIC.
}
\description{
This function estimates GARCHSK model's parameters.
}
\examples{
  library(GARCHSK)
  #load data
  data(GBP)
  
  # Estimate the parameters of GARCHSK model
  garchsk_GBP<-garchsk_est(GBP[1:100])
  
  # Parameters
  garchsk_GBP$params
}
