% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCD-package.R
\docType{data}
\name{paleofiresites}
\alias{paleofiresites}
\title{GCD sites information}
\format{
A data frame with 881 observations on the following 17 variables.
\describe{
  \item{\code{id_site}}{sites primary key from GCD v4.x.x}
 \item{\code{id_site_old}}{sites primary key from GCD v3.x.x, deprecated}
  \item{\code{pref_units}}{a factor, see help("charcoal_units") and data("charcoal_units") for details}
  \item{\code{site_name}}{a character vector}
  \item{\code{lat}}{a numeric vector}
  \item{\code{long}}{a numeric vector}
  \item{\code{elevation}}{a numeric vector of elevations}
  \item{\code{country}}{a character vector}
  \item{\code{continent}}{a factor with levels \code{Africa} \code{Antarctica} \code{Asia} \code{Australia} \code{Europe} \code{North America} \code{South America}}
  \item{\code{ISO3}}{ISO3 code by country}
  \item{\code{num_dating}}{a numeric vector}
  \item{\code{min_est_age}}{a numeric vector}
  \item{\code{max_est_age}}{a numeric vector}
  \item{\code{num_samp}}{a numeric vector}
  \item{\code{has_depth}}{factor indicating presence of depths associated to ages}
  \item{\code{date_int}}{a numeric vector, interval in years between two dates}
  \item{\code{qtype}}{a factor, see help("charcoal_units") and data("charcoal_units") for details}
  \item{\code{water_depth}}{a numeric vector}
  \item{\code{depo_context}}{a character vector, see help("depo_contex") and data("depo_contex") for details}
  \item{\code{id_site_type}}{a character vector, see help("site_type") and data("site_type") for details}
  \item{\code{id_basin_size}}{a character vector, see help("basin_size") and data("basin_size") for details}
  \item{\code{id_lands_desc}}{a character vector, see help("lands_desc") and data("lands_desc") for details}
  \item{\code{l12}}{a numeric vector, Levavasseur et al. 2012}
  \item{\code{rf99}}{a numeric vector, Ramankutty et al. 1999}
  \item{\code{gcd_version}}{main GCD releases}
  \item{\code{num_version}}{a numeric vector: version number 401 meaning 4.0.1}
  \item{\code{update_date}}{date of data update in the GCD}
}
}
\description{
Sites description and features
}
\details{
\describe{l12 levels}\code{0= Water} \cr \code{1= Boreal forest} \cr
\code{2= Desert vegetation} \cr \code{3= Grassland and dry shrubland} \cr
\code{4= Savannas abd dry woodlands} \cr \code{5= Temperate forest}\cr
\code{6= Tropical forest}\cr \code{7= Tundra}\cr \code{8= Warm temperate}\cr
\code{9= Warm desert}\cr \code{10= Cold desert}\cr

\describe{rf99 levels} \code{0= Water} \cr \code{1= Tropical Evergreen
Forest/Woodland}\cr \code{2= Tropical Deciduous Forest/Woodland}\cr \code{3=
Temperate Broadleaf Evergreen Forest/Woodland}\cr \code{4= Temperate
Needleleaf Evergreen Forest/Woodland}\cr \code{5= Temperate Deciduous
Forest/Woodland}\cr \code{6= Boreal Evergreen Forest/Woodland}\cr \code{7=
Boreal Deciduous Forest/Woodland}\cr \code{8= Evergreen/Deciduous Mixed
Forest/Woodland}\cr \code{9= Savanna}\cr \code{10= Grassland/Steppe}\cr
\code{11= Dense Shrubland}\cr \code{12= Open Shrubland}\cr \code{13=
Tundra}\cr \code{14= Desert}\cr \code{15= Polar Desert/Rock/Ice}\cr
}
\examples{

data(paleofiresites)
## maybe str(paleofiresites) ; plot(paleofiresites) ...

}
\references{
Ramankutty, N., and J.A. Foley (1999). Estimating historical
changes in global land cover: croplands from 1700 to 1992, Global
Biogeochemical Cycles 13(4), 997-1027.\cr \cr Levavasseur, G., M. Vrac, D.
M. Roche, and D. Paillard. 2012. Statistical modelling of a new global
potential vegetation distribution. Environmental Research Letters 7:044019.
}
\keyword{datasets}
