% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perc_baseline.R
\name{perc_baseline}
\alias{perc_baseline}
\title{Find the percent change from baseline}
\usage{
perc_baseline(Dataframe, Baseline.times, Baseline.frame = FALSE)
}
\arguments{
\item{Dataframe}{a GCalcium-format data frame or matrix}

\item{Baseline.times}{range of time from Baseline.frame to compute the baseline value from}

\item{Baseline.frame}{a GCalcium-format data frame or matrix containing the baseline period. If frame is not specified, Dataframe is automatically used}
}
\value{
a GCalcium-format data frame with values transformed to percent baseline
}
\description{
`perc_baseline` calculates the percent change from a user-specified baseline period
}
\examples{
### Format data frame
df.new <- format_data(GCaMP)

### Transform into percent baseline: relative to -3s to -1s before epoc
perc_baseline(Dataframe = df.new, Baseline.times = c(-3, -1))
}
