% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aSPU_apval.R
\name{aSPU_apval}
\alias{aSPU_apval}
\title{Asymptotic based Sum of Powered Score (SPU) tests and adaptive SPU (aSPU) test.}
\usage{
aSPU_apval(Y, X, cov = NULL, pow = c(1:6, Inf), resample = "boot",
  model = "gaussian", n.perm = 5000)
}
\arguments{
\item{Y}{Response. It can be binary or continuous trait. A vector with length n (number of observations).}

\item{X}{Genotype or other data; each row for a subject, and each column for a variable of interest. An n by p matrix (n: number of observations, p: number of predictors).}

\item{cov}{Covariates. An n by q matrix (n: number of observations, q: number of covariates).}

\item{pow}{Gamma set used in SPU test. A vector of the powers.}

\item{resample}{Resample methods. "perm" for residual permutations; "boot" for parametric bootstrap.}

\item{model}{corresponding to the Response. "gaussian" for a quantitative response; "binomial" for a binary response.}

\item{n.perm}{number of permutations or bootstraps.}
}
\value{
A list object, Ts : test statistics for the SPU tests and the aSPU test.
        pvs : p-values for the SPU and aSPU tests.
}
\description{
It gives p-values of the SPU tests and aSPU test.
}
\examples{

p = 200
n = 100
beta = c(1,3,3)
s = 0.15
non.zero = floor(p * s)
signal.r = 0.08
seed = 2
alpha = c(rep(signal.r,non.zero),rep(0,p-non.zero))
dat = generate_data(seed, n = n, p = p, beta = beta,alpha = alpha)
cov = dat$Z
X = dat$X
Y = dat$Y
aSPU_apval(Y, X, cov = cov, pow = c(1:6, Inf),resample = "perm", model = "gaussian",  n.perm = 1000)
# The p-values are similar to the resample based one

}
\author{
Chong Wu and Wei Pan
}
\references{
Chong Wu, Gongjun Xu and Wei Pan, "An Adaptive test on high dimensional parameters in generalized linear models" (Submitted)
}

