% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_boxplot.R
\name{flex_boxplot}
\alias{flex_boxplot}
\title{flex_boxplot function}
\usage{
flex_boxplot(
  distribution_data,
  interactive = TRUE,
  user_colors = NULL,
  user_title = "Boxplot",
  user_x_title = NULL,
  user_y_title = NULL,
  user_legend_title = NA,
  user_plot_theme = theme_minimal(),
  user_plot_theme_specs = theme(legend.title = element_blank(), legend.text =
    element_text(size = 10), title = element_text(size = 15), axis.text.x =
    element_text(size = 10), axis.title.x = element_text(size = 10), axis.text.y =
    element_text(size = 10), axis.title.y = element_text(size = 10)),
  annotate_stats = FALSE,
  annotate_outliers = FALSE,
  annotate_stats_text_size = 3.5,
  annotate_outliers_text_size = 3,
  annotate_stats_text_color = "black",
  annotate_outliers_text_color = "darkred",
  annotate_outliers_text_vjust = -1,
  annotate_stats_text_vjust = 1.5,
  annotate_outliers_text_hjust = -0.5,
  annotate_stats_text_hjust = 1
)
}
\arguments{
\item{distribution_data}{A dataframe where each column represents a data
distribution (e.g. population) to be plotted with minimum of a single column.}

\item{interactive}{Logical; if TRUE, the output is an interactive Plotly
graph. Defaults to TRUE.}

\item{user_colors}{A vector of colors to be used for the boxplots. If NULL,
a default set of colors is used.}

\item{user_title}{The main title of the plot. Defaults to "Boxplot".}

\item{user_x_title}{Custom title for the x-axis. If NULL, defaults to the
column names of distribution_data.}

\item{user_y_title}{Custom title for the y-axis. If NULL, defaults to "Values".}

\item{user_legend_title}{Title for the legend. Use NA to hide the legend.
Defaults to NA.}

\item{user_plot_theme}{A ggplot2 theme object to customize the appearance of
the plot. Defaults to theme_minimal().}

\item{user_plot_theme_specs}{Additional ggplot2 theme specifications.}

\item{annotate_stats}{Logical; if TRUE, adds text annotations for basic
statistics (min, Q1, median, Q3, max) to the plot.}

\item{annotate_outliers}{Logical; if TRUE, adds text annotations for outliers
to the plot.}

\item{annotate_stats_text_size}{Numeric; text size for statistics annotations.
Defaults to 3.5.}

\item{annotate_outliers_text_size}{Numeric; text size for outliers annotations.
Defaults to 3.}

\item{annotate_stats_text_color}{Character; text color for statistics annotations.
Defaults to "black".}

\item{annotate_outliers_text_color}{Character; text color for outliers annotations.
Defaults to "darkred".}

\item{annotate_outliers_text_vjust}{Numeric; vertical adjustment for outliers
text annotations.}

\item{annotate_stats_text_vjust}{Numeric; vertical adjustment for statistics
text annotations.}

\item{annotate_outliers_text_hjust}{Numeric; horizontal adjustment for outliers
text annotations.}

\item{annotate_stats_text_hjust}{Numeric; horizontal adjustment for statistics
text annotations.}
}
\value{
Depending on the value of \code{interactive}, returns either a Plotly
object and/or a ggplot object.
}
\description{
This function creates a flexible, optionally interactive boxplot which can
be customized with different themes, colors, and additional annotations. It
supports both traditional and interactive (Plotly) outputs.
}
\examples{
library(ggplot2)
library(plotly)
library(dplyr)
library(nortest)
library(ggforce)
library(reshape2)
library(gridExtra)
library(grid)
library(cowplot)
# Basic interactive boxplot
flex_boxplot(example_data8)

# Boxplot with custom colors, themes and titles
flex_boxplot(example_data8, user_plot_theme = ggplot2::theme_gray(), 
            user_colors = c("#6A3D9A", "#FF7F00", "gold1"), 
            user_title = "Customized Boxplot",
          user_x_title = "Multiple Populations",
          user_y_title = "Values",
          user_legend_title = "Multiple Populations",
          user_plot_theme_specs = ggplot2::theme(
            legend.title = ggplot2::element_text(size = 10),
            legend.text = ggplot2::element_text(size = 10),
            title = ggplot2::element_text(size = 20),
            axis.text.x = ggplot2::element_blank(),
            axis.title.x = ggplot2::element_text(size = 15),
            axis.text.y = ggplot2::element_text(size = 12),
            axis.title.y = ggplot2::element_text(size = 15)
          ))
}
