% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concat.R
\name{concat}
\alias{concat}
\title{Concat Concatenates separated time series}
\usage{
concat(svrlTS, winL = 9)
}
\arguments{
\item{svrlTS}{All separated time series.}

\item{winL}{Total number of points used for computing the derivatives
of the input time series. This parameter will be used as an
input in function \code{drvSucc} to compute the derivatives.}
}
\value{
\code{concaTS} The concatenated time series.
}
\description{
The aim of this code is to provide, from a set of multiple
time series, a single concatenated time series for applying the global
modeling technique to all the time time series in association.
}
\examples{
# load data
data("svrlTS")
# Concatenate the data set into a single time series
winL = 55
concaTS <- concat(svrlTS, winL = winL)
# Plot the concatenated time series
plot(concaTS$sglTS$TS[,1], concaTS$sglTS$TS[,2],
     main = 'Concatenated time series',
     xlab = 'Time (concatenated)', ylab = 'y(t)',
     type = 'l', col = 'gray')
lines(concaTS$sglTS$TS[concaTS$sglTS$W == 1,1],
      concaTS$sglTS$TS[concaTS$sglTS$W == 1,2], type = 'p', col = 'green', cex = 0.5)
lines(concaTS$sglTS$TS[concaTS$sglTS$W == 0,1],
      concaTS$sglTS$TS[concaTS$sglTS$W == 0,2], type = 'p', col = 'red', cex = 0.5)
lines(concaTS$sglTS$TS[,1], concaTS$sglTS$W, type = 'l')
\donttest{
# The concatenated data set can be used for global modelling:
GPout1 <- gPoMo(data = concaTS$sglTS$TS[,2], tin = concaTS$sglTS$TS[,1],
                dMax = 2, nS = 3, winL = winL, weight = concaTS$sglTS$W, show = 1,
                IstepMin = 10, IstepMax = 6000, nPmin = 11, nPmax = 11, method = 'rk4')
}

}
\references{
S. Mangiarotti, F. Le Jean, M. Huc & C. Letellier, 2016.
Global modeling of aggregated and associated chaotic dynamics,
Chaos, Solitons & Fractals, 83, 82-96.
}
\author{
Sylvain Mangiarotti, Mireille Huc
}
