% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regOrd.R
\name{regOrd}
\alias{regOrd}
\title{Generate the conventional order for polynomial terms
in a the polynomial formulation}
\usage{
regOrd(nVar, dMax, dMin = 0)
}
\arguments{
\item{nVar}{The number of variables}

\item{dMax}{The maximum degree allowed in the formulation}

\item{dMin}{The minimum negative degree of the polynomial
formulation (0 by default).}
}
\value{
A matrix of exponents. Each column corresponds to one
polynomial term. Each line correspond to the exponent of one
variable.
For example, a column of three exponents \code{(0,2,1)} corresponds
to the monomial \code{X1^0 * X2^2 * X3^1}, that is \eqn{X2^2 X3}.
}
\description{
Generate the conventional order of the polynomial
terms for the polynomial description.
It is formulated as a matrix of exponents: Each
column of the matrix (a,b,c, ...) corresponds to a product
of the \code{nVar} available variables X1, X2, X3, etc.,
that is, \eqn{X1^a X2^b X3^c}, etc.
}
\seealso{
\code{\link{poLabs}}
}
\author{
Sylvain Mangiarotti
}
