% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWexPrec_lib.r
\name{fit.MAR1.amount}
\alias{fit.MAR1.amount}
\title{fit.MAR1.amount}
\usage{
fit.MAR1.amount(P.mat, isPeriod, th, copulaInt, M0, A)
}
\arguments{
\item{P.mat}{precipitation matrix}

\item{isPeriod}{vector of logical n x 1 indicating the days concerned by a 3-month period}

\item{th}{threshold above which we consider that a day is wet (e.g. 0.2 mm)}

\item{copulaInt}{type of dependance between inter-site amounts: 'Gaussian' or 'Student'}

\item{M0}{covariance matrix of gaussianized prec. amounts for all pairs of stations}

\item{A}{Matrix containing the autocorrelation (temporal) correlations}
}
\value{
list with the following items
\itemize{
  \item \strong{M0} covariance matrix of gaussianized prec. amounts for all pairs of stations
  \item \strong{A} omega correlations for all pairs of stations
  \item \strong{covZ} covariance matrix of the MAR(1) process
  \item \strong{sdZ} standard deviation of the diagonal elements
  \item \strong{corZ} correlation matrix of the MAR(1) process
  \item \strong{dfStudent} degrees of freedom for the Student copula if CopulaInt is equal to "Student"
}
}
\description{
estimate parameters which control the dependence between intensities with a
MAR(1) process
}
\references{
Matalas, N. C. 1967. “Mathematical Assessment of Synthetic Hydrology.” Water Resources 
Research 3 (4): 937–45. https://doi.org/10.1029/WR003i004p00937.

Bárdossy, A., and G. G. S. Pegram. 2009. “Copula Based Multisite Model for Daily 
Precipitation Simulation.” Hydrology and Earth System Sciences 13 (12): 2299–2314. https://doi.org/10.5194/hess-13-2299-2009.
}
\author{
Guillaume Evin
}
