% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWexPrec_lib.r
\name{infer.mat.omega}
\alias{infer.mat.omega}
\title{infer.mat.omega}
\usage{
infer.mat.omega(P.mat, isPeriod, th, nLag, pr.state, nChainFit, isParallel)
}
\arguments{
\item{P.mat}{matrix of precipitation n x p}

\item{isPeriod}{vector of logical n x 1 indicating the days concerned by a 3-month period}

\item{th}{threshold above which we consider that a day is wet (e.g. 0.2 mm)}

\item{nLag}{order of the Markov chain}

\item{pr.state}{output of function \code{\link{lagTransProbaMatrix}}}

\item{nChainFit}{length of the simulated chains used during the fitting}

\item{isParallel}{logical: indicate computation in parallel or not (easier for debugging)}
}
\value{
A list with different objects 
\itemize{
  \item \strong{Qtrans.mat}: matrix nStation x n.comb of transition probabilites
  \item \strong{mat.comb}: matrix of possible combination n.comb x nLag
  \item \strong{mat.omega}: The spatial correlation matrix of occurrences \eqn{\Omega} (see Evin et al., 2018).
}
}
\description{
find omega correlation leading to estimates cor between occurrences
}
\author{
Guillaume Evin
}
