% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gwl_map.R
\name{plot_gwl_map}
\alias{plot_gwl_map}
\title{Plot a map of beta coefficient for gwlfit object}
\usage{
plot_gwl_map(x, column, crs = 4326)
}
\arguments{
\item{x}{a \code{gwlfit} object returned by \code{\link[=gwl_fit]{gwl_fit()}}.}

\item{column}{the name of a variable to be plotted on the map. Must be quoted. for instance "NEB.MIN"}

\item{crs}{the crs projection for the map (default is mercator WGS84). See \code{\link[sf:st_crs]{sf::st_crs()}}}
}
\value{
a ggplot object
}
\description{
this function plots a map of the beta coefficients for a selected column (aka species).
For this function to work, the coordinates supplied to \code{\link[=gwl_fit]{gwl_fit()}} must be named "Lat" and "Long".
The function is not bulletproof yet but is added here to reproduce the maps from the original publication.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{

data(Amesbury)
  
distance_matrix <- compute_distance_matrix(Amesbury$coords[1:30,], add.noise = TRUE)
  
my.gwl.fit <- gwl_fit(bw= 20,
                      x.var = Amesbury$spe.df[1:30,],
                      y.var = Amesbury$WTD[1:30],
                      dist.mat = distance_matrix,
                      adaptive = TRUE,
                      kernel = "bisquare",
                      alpha = 1,
                      progress = TRUE)
                        
if(requireNamespace("maps")){
    plot_gwl_map(my.gwl.fit, column = "NEB.MIN")
  }
  
}
