% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa.R
\name{kappa}
\alias{kappa}
\title{Change-point statistics for GOU}
\usage{
kappa(theta, theta_star, sigma)
}
\arguments{
\item{theta}{list of parameters before change-point: cos coefficients (>=1), sine coefficients (>=0, and alpha}

\item{theta_star}{list of parameters after  change-point: cos coefficients (>=1), sine coefficients (>=0, and alpha}

\item{sigma}{volatility parameter of the GOU process}
}
\value{
\item{out}{List containing Sigma and kappas for Q and G statistics}
}
\description{
Function to compute Sigma covariance matrix and kappas of change-point statistics
}
\examples{
theta=list(cos=c(1,2),alpha=1)
theta_star=list(cos=c(2,4),alpha=2)
sigma=3
out = kappa(theta,theta_star, sigma)
}
