% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mongodb_console}
\alias{mongodb_console}
\title{MongoDB (bulk) commands}
\usage{
mongodb_console(Argument = NULL, ...)
}
\arguments{
\item{Argument}{a character string specifying the mongodb shell command to run from within an R-session}

\item{...}{the \emph{ellipsis} (...) parameter allows a unix-user (windows-user) to give additional parameters to the base-R \emph{system() (shell())} function which is run in background.}
}
\description{
MongoDB (bulk) commands
}
\details{
MongoDB shell commands are important for instance if someone has to import/export bulk data to a mongo database. This R function utilizes the \emph{system} base function to run the mongodb shell command from
within an R-session. See the reference links for more details.
The \emph{ellipsis} (...) parameter could be used for instance to disallow messages be printed in the console (on unix by using \emph{ignore.stdout} and \emph{ignore.stderr}).
}
\examples{

\dontrun{

library(GeoMongo)

ARGs = "mongoimport -d DB -c COLLECTION --type json --file /MY_DATA.json"

mongodb_console(Argument = ARGs)

}
}
\references{
https://docs.mongodb.com/database-tools/mongoimport/, https://docs.mongodb.com/database-tools/mongoexport/
}
