% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_violin.R
\name{plot_violin}
\alias{plot_violin}
\title{Violin plot}
\usage{
plot_violin(
  x,
  method = "anova",
  method_adjust = "BH",
  title = NULL,
  width_text = 20,
  width_title = 20,
  colour = "red",
  color_title = colour,
  pch_alpha = 1,
  pch_colour = "gray50",
  pch_size = cex,
  cex = 1,
  cex_axis = 17 * cex,
  cex_main = 21 * cex,
  cex_sub = 15 * cex,
  stats = TRUE,
  digits = 0,
  alpha = 0.3,
  coef = 1.5,
  hjust = 0.5,
  lwd = 1,
  probs = c(0.25, 0.75),
  subtitle = FALSE,
  ylab = NULL
)
}
\arguments{
\item{x}{Vector or data.frame of numerical values visualized on the plot.}

\item{method}{Character for the test method ('anova', 'kruskal', or
'wilcox').}

\item{method_adjust}{Character for the multiple correction test among
'BH', 'BY', 'bonferroni', 'fdr', 'hochberg', 'holm', 'hommel', 'none'}

\item{title}{Character for the title.}

\item{width_text}{Integer for the maximum length of the subtitle(s).}

\item{width_title}{Integer for the maximum length of the title.}

\item{colour}{Color or vector of colors for the violin and boxplot.}

\item{color_title}{Color for the title.}

\item{pch_alpha}{Integer for the transparency of the points (ranging from 0
to 1 for maximum opacity).}

\item{pch_colour}{Color for the sina points.}

\item{pch_size}{Integer for the magnification factor for the points relative
to the default.}

\item{cex}{Integer for the magnification factor for the text relative to the
default.}

\item{cex_axis}{Integer for the magnification factor for the axis labels
relative to the default.}

\item{cex_main}{Integer for the magnification factor for the subtitles
relative to the default.}

\item{cex_sub}{Integer for the magnification factor for the main title
relative to the default.}

\item{stats}{Boolean to display the results of statistical tests.}

\item{digits}{Integer for the number of decimals.}

\item{alpha}{Integer for the transparency of the violin plot
(ranging from 0 to 1 for maximum opacity)}

\item{coef}{Integer to multiply the quantiles by.}

\item{hjust}{Integer for the horizontal justification (in [0,1]).}

\item{lwd}{Integer for the line width.}

\item{probs}{Integer vector of probabilities (in [0,1]).}

\item{subtitle}{Character for the subtitle.}

\item{ylab}{Character for the title of the Y-axis.}
}
\value{
A ggplot object.
}
\description{
Visualize the distribution of single or multiple variables using violin
plots, boxplots, and sina plots
}
\examples{
library(RColorBrewer)

# Default plot
x <- runif(10)
plot_violin(x)

# Advanced parameters
df <- lapply(seq(2), function(x) runif(10))
df <- as.data.frame(df)
df[, 3] <- runif(10, 1, 2)
colnames(df) <- paste0("X", seq(3))
plot_violin(
    df,
    title = "Some random variables",
    color_title = brewer.pal(9, "Set1")[5],
    ylab = "Y-values",
    colour = brewer.pal(9, "Set1")[seq(3)],
    method = "kruskal",
    method_adjust = "none",
    cex = 1.2,
    pch_size = 3,
    width_text = 5,
    pch_colour = "gray30",
    pch_alpha = 0.5,
    width_title = 30,
    lwd = 1.25,
    digits = 2
)

}
