% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obozinski.methods.R
\name{obozinski.heuristic.methods}
\alias{obozinski.heuristic.methods}
\alias{obozinski.max}
\alias{obozinski.and}
\alias{obozinski.or}
\title{Obozinski heuristic methods}
\usage{
obozinski.max(S, g, root = "00")

obozinski.and(S, g, root = "00")

obozinski.or(S, g, root = "00")
}
\arguments{
\item{S}{a named flat scores matrix with examples on rows and classes on columns.}

\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes.}

\item{root}{name of the class that it is the top-level of the hierarchy (\code{def:00}).}
}
\value{
A matrix with the scores of the classes corrected according to the chosen Obozinski's heuristic algorithm.
}
\description{
Implementation of the Obozinski's heuristic methods \code{Max}, \code{And}, \code{Or} (\cite{Obozinski et al., Genome Biology, 2008,
\doi{10.1186/gb-2008-9-s1-s6}}).
}
\details{
Obozinski's heuristic methods:
\enumerate{
 \item \bold{Max}: reports the largest logistic regression (LR) value of self and all descendants: \eqn{p_i = max_{j \in descendants(i)} \hat{p_j}};
 \item \bold{And}: reports the product of LR values of all ancestors and self. This is equivalent to computing the probability that all
  ancestral terms are "on" assuming that, conditional on the data, all predictions are independent: \eqn{p_i = \prod_{j \in ancestors(i)} \hat{p_j}};
 \item \bold{Or}: computes the probability that at least one of the descendant terms is "on" assuming again that, conditional on the data,
  all predictions are independent: \eqn{1 - p_i = \prod_{j \in descendants(i)} (1 - \hat{p_j})};
}
}
\examples{
data(graph);
data(scores);
root  <- root.node(g);
S.max <- obozinski.max(S,g,root);
S.and <- obozinski.and(S,g,root);
S.or  <- obozinski.or(S,g,root);
}
