% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perf.meas.R
\name{stratified.cross.validation}
\alias{stratified.cross.validation}
\alias{stratified.cv.data.single.class}
\alias{stratified.cv.data.over.classes}
\title{Stratified cross validation}
\usage{
stratified.cv.data.single.class(examples, positives, kk = 5, seed = NULL)

stratified.cv.data.over.classes(labels, examples, kk = 5, seed = NULL)
}
\arguments{
\item{examples}{indices or names of the examples. Can be either a vector of integers or a vector of names.}

\item{positives}{vector of integers or vector of names. The indices (or names) refer to the indices (or names) of 'positive' examples.}

\item{kk}{number of folds (\code{def. kk=5}).}

\item{seed}{seed of the random generator (\code{def. seed=NULL}). If is set to \code{NULL} no initialization is performed.}

\item{labels}{labels matrix. Rows are genes and columns are classes. Let's denote \eqn{M} the labels matrix.
If \eqn{M[i,j]=1}, means that the gene \eqn{i} is annotated with the class \eqn{j}, otherwise \eqn{M[i,j]=0}.}
}
\value{
\code{stratified.cv.data.single.class} returns a list with 2 two component:
\itemize{
 \item fold.non.positives: a list with \eqn{k} components. Each component is a vector with the indices (or names) of the non-positive elements.
    Indexes (or names) refer to row numbers (or names) of a data matrix;
    \item fold.positives: a list with \eqn{k} components. Each component is a vector with the indices (or names) of the positive elements.
    Indexes (or names) refer to row numbers (or names) of a data matrix;
}

\code{stratified.cv.data.over.classes} returns a list with \eqn{n} components, where \eqn{n} is the number of classes of the labels matrix.
Each component \eqn{n} is in turn a list with \eqn{k} elements, where \eqn{k} is the number of folds.
Each fold contains an equal amount of positives and negatives examples.
}
\description{
Generate data for the stratified cross-validation.
}
\details{
Folds are \emph{stratified}, i.e. contain the same amount of positive and negative examples.
}
\examples{
data(labels);
examples.index <- 1:nrow(L);
examples.name <- rownames(L);
positives <- which(L[,3]==1);
x <- stratified.cv.data.single.class(examples.index, positives, kk=5, seed=23);
y <- stratified.cv.data.single.class(examples.name, positives, kk=5, seed=23);
z <- stratified.cv.data.over.classes(L, examples.index, kk=5, seed=23);
k <- stratified.cv.data.over.classes(L, examples.name, kk=5, seed=23);
}
