% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hIndxMeanCalc4Traits.R
\name{hIndxMeanCalc4Traits}
\alias{hIndxMeanCalc4Traits}
\title{Calculate Mean Heritability Index for Traits}
\usage{
hIndxMeanCalc4Traits(hIndexValDF)
}
\arguments{
\item{hIndexValDF}{A data frame containing heritability index values with at least two columns: \code{Trait.name} and \code{Heritability}.
The \code{Trait.name} column should contain trait identifiers, and the \code{Heritability} column should contain numeric heritability values.}
}
\value{
A data frame with two columns: \code{Trait.name} and \code{MeanValue}, where \code{MeanValue} represents the mean heritability for each trait.
}
\description{
This function processes heritability index data, filtering out empty trait names, and calculates the mean heritability for each unique trait. The resulting output is a data frame with traits and their corresponding mean heritability values.
}
\examples{
\donttest{
# Example of usage:
hIndexValDF <- data.frame(Trait.name = c("Trait1", "Trait2", "Trait1", "Trait2"),
                          Heritability = c(0.5, 0.6, 0.7, 0.8))
result <- hIndxMeanCalc4Traits(hIndexValDF)
print(result)
}

}
\references{
Hu et al. (2018) \doi{10.1093/nar/gky1084}
}
