% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/31_pre_processing_functions.R
\name{fit_lasso}
\alias{fit_lasso}
\title{Fit a (group) Lasso logistic regression classifier}
\usage{
fit_lasso(
  control_train,
  treat_train,
  lambda_type = c("lambda.min", "lambda.1se"),
  classifier_method = c("lasso", "group_lasso"),
  group = NULL
)
}
\arguments{
\item{control_train}{A matrix or data frame for the control group. Rows are samples, columns are features.}

\item{treat_train}{A matrix or data frame for the treatment group. Rows are samples, columns are features.}

\item{lambda_type}{Character. Type of lambda to use from cross-validation. Options are \code{"lambda.min"} (default) and \code{"lambda.1se"}.}

\item{classifier_method}{Character. Choice of classifier. \code{"lasso"} (default) or \code{"group_lasso"}.}

\item{group}{Optional grouping vector for \code{group_lasso}, same length as the number of columns in the input data.}
}
\value{
A numeric vector of estimated regression coefficients (excluding intercept), thresholded for small values.
}
\description{
Performs Lasso or group Lasso logistic regression to distinguish between two groups of samples.
}
\details{
The function fits a logistic regression using either \code{glmnet} for Lasso or \code{grpreg} for group Lasso.
Coefficients are soft-thresholded by the maximum coefficient times \code{n^(-1/3)} where \code{n} is the effective sample size.
}
\examples{
\dontrun{
X1 <- matrix(rnorm(100), nrow = 10)
X2 <- matrix(rnorm(100), nrow = 10)
fit_lasso(X1, X2, classifier_method = "lasso")
}

}
