\encoding{UTF-8}
\name{viterbi}
\alias{viterbi}
\title{Computes the Most Probable Path of States}
\description{
The Viterbi algorithm computes the most probable path of states for a sequence
of observations given a Hidden Markov Model.
}
\usage{
viterbi(hmm, observation)
}
\arguments{
  \item{hmm}{A valid Hidden Markov Model, for example instantiated by \code{\link{initHMM}}.}
  \item{observation}{A vector of observations.}
}
\value{
A vector of strings containing the most probable path of states.
}
\references{
Lawrence R. Rabiner: A Tutorial on Hidden Markov Models and Selected Applications
in Speech Recognition. Proceedings of the IEEE 77(2), pp. 257-286, 1989.
}
\examples{
# Initialise HMM
hmm = initHMM(c("A","B"), c("L","R"), transProbs=matrix(c(.6,.4,.4,.6),2),
              emissionProbs=matrix(c(.6,.4,.4,.6),2))
print(hmm)
# Sequence of observations
observations = c("L","L","R","R")
# Calculate Viterbi path
viterbi = viterbi(hmm, observations)
print(viterbi)
}
\keyword{methods}
\author{Lin Himmelmann \email{hmm@linhi.de}}
