% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdn_PaleyI.R
\name{cdn_PaleyI}
\alias{cdn_PaleyI}
\title{cdn_PaleyI
Checks Hadamard Matrix can be constructed using Paley I method.}
\usage{
cdn_PaleyI(order)
}
\arguments{
\item{order}{integer}
}
\value{
2 or NULL
}
\description{
cdn_PaleyI
Checks Hadamard Matrix can be constructed using Paley I method.
}
\details{
In Paley I method,  if q=order-1 and q is prime number and q=3 (mod 4) then the function retuns 2 otherwise NULL.
}
\examples{
cdn_PaleyI(8)
#2
cdn_PaleyI(16)
#NULL
}
\references{
Paley, R.E.A.C. (1933). On Orthogonal matrices. J. Combin. Theory, A 57(1), 86-108.
}
\seealso{
\code{\link{PaleyI}} for Paley I construction method.
}
