% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdn_cooper.R
\name{cdn_cooper}
\alias{cdn_cooper}
\title{cdn_cooper}
\usage{
cdn_cooper(order)
}
\arguments{
\item{order}{integer}
}
\value{
11 or NULL
}
\description{
Checks Hadamard Matrix can be constructed using Williamson arrays and T- sequences.
}
\details{
Cooper-Wallis is a construction of Hadamard matrices which combines
Williamson matrices and T-sequences.

The availabile Williamson sequences in the internal data sets is
seq(1,63, 2) except 15, 35, 47, 53, 59 in the internal table.

The availabile T- sequences in the internal data sets is seq(1,73,2) and
83, 101, 107.
}
\examples{
cdn_cooper(20)
#11
cdn_cooper(16)
#NULL
}
\references{
Cooper, J., and Wallis, W., D. (1972). A construction for Hadamard arrays. Bull. Austral. Math. 7, 269-278.
}
\seealso{
\code{\link{had_cooper}} for Cooper-Wallis construction method.
 \code{\link{get_cooper}} for finding order of Williamson and T-Sequences.
}
