% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggamma.R
\name{dggamma}
\alias{dggamma}
\alias{pggamma}
\alias{qggamma}
\alias{rggamma}
\title{Generalized gamma distribution.}
\usage{
dggamma(x, theta, kappa, delta, log = FALSE)

pggamma(q, theta, kappa, delta, lower.tail = TRUE, log.p = FALSE)

qggamma(p, theta, kappa, delta, lower.tail = TRUE, log.p = FALSE)

rggamma(n, theta, kappa, delta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{scale parameter.}

\item{kappa}{shape parameter.}

\item{delta}{shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities \emph{p} are given as \emph{log(p)}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \emph{P[X <= x]} otherwise, \emph{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dggamma} gives the density, \code{pggamma} gives the distribution function,
\code{qggamma} gives the quantile function, and \code{rggamma} generates random deviates.
}
\description{
Generalized gamma distribution
}
\details{
\code{pggamma}, \code{qggamma}, \code{dggamma}, and \code{rggamma} are used to model the
generalized gamma distribution.

The code is modified from \url{https://rpubs.com/FJRubio/GG}.
}
\section{Functions}{
\itemize{
\item \code{dggamma()}: Density of the generalized gamma.

\item \code{pggamma()}: Distribution function of the generalized gamma.

\item \code{qggamma()}: Quantile of the generalized gamma.

\item \code{rggamma()}: Random of the generalized gamma.

}}
\section{More details here}{

The generalized gamma is described here \url{https://en.wikipedia.org/wiki/Generalized_gamma_distribution}.\cr
With \code{a} being \code{theta}, \code{b} being \code{kappa}, and \code{p} being \code{delta}.\cr
\code{theta}, \code{kappa} and \code{delta} must be all > 0.
}

\examples{
# To reproduce the wikipedia page graphic
x <- seq(from=0, to=8, by=0.1)
plot(x, dggamma(x, theta=2, kappa=0.5, delta=0.5), lty=1, col="blue", 
     type="l", lwd=2, xlab="x", ylab="PDF")
lines(x, dggamma(x, theta=1, kappa=1, delta=0.5), lty=1, col="green", lwd=2)
lines(x, dggamma(x, theta=2, kappa=1, delta=2), lty=1, col="red", lwd=2)
lines(x, dggamma(x, theta=5, kappa=1, delta=5), lty=1, col="yellow", lwd=2)
lines(x, dggamma(x, theta=7, kappa=1, delta=7), lty=1, col="grey", lwd=2)
legend("topright", legend=c("a=2, d=0.5, p=0.5", "a=1, d=1, p=0.5", 
                            "a=2, d=1, p=2", "a=5, d=1, p=5", "a=7, d=1, p=7"), 
                            col=c("blue", "green", "red", "yellow", "grey"), 
                            lty=1, lwd=2, bty="n")
par <- c(theta=2, kappa=0.5, delta=0.5)
# Mean, var and sd
mean.ggamma <- function(theta, kappa, delta) 
       return(theta*(gamma((kappa+1)/delta))/gamma(kappa/delta))
var.ggamma <- function(theta, kappa, delta) 
       return(theta^2* ( ( (gamma((kappa+2)/delta))/gamma(kappa/delta) ) - 
                ( (gamma((kappa+1)/delta))/gamma(kappa/delta) )^2 ) )
sd.ggamma <- function(theta, kappa, delta) 
       return(sqrt(theta^2* ( ( (gamma((kappa+2)/delta))/gamma(kappa/delta) ) - 
                ( (gamma((kappa+1)/delta))/gamma(kappa/delta) )^2 ) ))
}
\seealso{
Other Distributions: 
\code{\link{cutter}()},
\code{\link{dSnbinom}()},
\code{\link{dbeta_new}()},
\code{\link{dcutter}()},
\code{\link{logLik.cutter}()},
\code{\link{plot.cutter}()},
\code{\link{print.cutter}()},
\code{\link{r2norm}()},
\code{\link{rcutter}()},
\code{\link{rmnorm}()},
\code{\link{rnbinom_new}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Distributions}
