% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HighestMedianRules.R
\name{gauges}
\alias{gauges}
\title{Gauges}
\usage{
gauges(grades, k = 0.5, scale = c(), return = "qp")
}
\arguments{
\item{grades}{A numeric vector containing the shares of each grades of a candidate, from the lowest grade to the highest.}

\item{k}{The quantile used to compute the gauge. Default to 0.5 (the median). For more details, see paragraph Extensions in 3.2.1 of "Tie-Breaking the Highest Median", Fabre, Social Choice & Welfare (forthcoming).}

\item{scale}{A numeric vector containing the values of the scale of grades. Default to c((floor(-length(grades)/2)+1):(length(grades)+floor(-length(grades)/2))).}

\item{return}{A string containing the information to return. Default to 'qp' (shares of opponents and proponents). Possible values: 'g', 'p', 'q', 'pq', 'qp', 'qpg', 'pqg', 'gpq', 'gqp', 'text' (i.e. the gauge), 'all'. If the string does not match one of the above, 'all' is returned.}
}
\value{
An array with as many columns as elements of \code{grades}, with the return of \code{gauge} in each column.
}
\description{
Aggregator of 'gauge': returns the gauge of each row (i.e. candidate) from a matrix (i.e. the voting profile). See function 'gauge'.
}
\examples{
gauges(grades = elec2012, return = 'gqp')
}
