% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HighestMedianRules.R
\name{ranking}
\alias{ranking}
\title{Ranking}
\usage{
ranking(
  grades,
  rule = "mj",
  k = 0.5,
  scale = c(),
  names = row.names(grades),
  print = FALSE
)
}
\arguments{
\item{grades}{A voting profile, i.e. a matrix with the shares of grades of each candidate on each row, from the lowest grade to the highest.}

\item{rule}{The voting rule to be used. Default to 'mj'. Possible values: 'mj' (majority judgment), 'd' (difference), 's' (relative share), 'n' (normalized difference), 'mean' (range voting). For more details, see "Tie-Breaking the Highest Median", Fabre, Social Choice & Welfare (forthcoming).}

\item{k}{The quantile used to compute the gauge. Default to 0.5 (the median). For more details, see paragraph Extensions in 3.2.1 of "Tie-Breaking the Highest Median", Fabre, Social Choice & Welfare (forthcoming).}

\item{scale}{A numeric vector containing the values of the scale of grades. Default to c((floor(-length(grades)/2)+1):(length(grades)+floor(-length(grades)/2))).}

\item{names}{String vector, each string to be printed in case print = TRUE. Defaults to c().}

\item{print}{Prints the argument 'names'. Default to FALSE}
}
\value{
A character matrix with as many rows as elements of \code{grades}, and with the name, gauge and score (according to \code{rule}) on each row.
}
\description{
Returns a matrix with the scores of candidates sorted in decreasing order, for a given voting rule.
}
\examples{
ranking(elec2012, rule='d', scale=-2:4)
}
