% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_HBay.R
\name{HBay_Plot}
\alias{HBay_Plot}
\title{HBay plot}
\usage{
HBay_Plot(H3, curve_color = "black")
}
\arguments{
\item{H3}{list, resulting from a call to Hydro3_HBay()}

\item{curve_color}{color, color used for quantile curve}
}
\value{
nothing (just creates a plot)
}
\description{
Plot summarizing the results of Hydro3_HBay()
}
\examples{
set.seed(98765)
n=50;n_censored=30
y0=Generate('GEV',c(100,50,-0.2),n)
y=cbind(y0,y0)
# Mimics censoring between 0 and 300 for first n_censored years
y[1:n_censored,1][y0[1:n_censored]<300]=0
y[1:n_censored,2][y0[1:n_censored]<300]=300
plot(y[,1]);points(y[,2])
# Systematic errors
SystErrorIndex=c(rep(1,n_censored),rep(2,n-n_censored))
SystErrorPrior=list(list(dist="Triangle",par=c(1,0.7,1.3)),
                    list(dist="Triangle",par=c(1,0.95,1.05)))
# Priors on GEV parameters
prior=list(list(dist="FlatPrior",par=NULL),
           list(dist="FlatPrior",par=NULL),
           list(dist="Normal",par=c(0,0.25)))
# Handle MCMC options
# The values below aim at making this example fast to run.
# In practice, it is recommended to use the default values
# (batch.length=100,batch.n=100) or larger.
mcmcoptions=mcmcoptions_def
mcmcoptions$batch.length=25
mcmcoptions$batch.n=20
# Go!
H3=Hydro3_HBay(y=y,dist='GEV',prior=prior,
               SystErrorIndex=SystErrorIndex,
               SystErrorPrior=SystErrorPrior,
               mcmcoptions=mcmcoptions) 
# HBay plot
HBay_Plot(H3)
}
