% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2cov.R
\name{str2cov}
\alias{str2cov}
\title{converts a ICED measurement structure data.frame and a vector}
\usage{
str2cov(structure, variances, e_label = "e")
}
\arguments{
\item{structure}{data.frame describing the structure of the data, with each variable convering a design aspect - see example. Note: currently the first variable must be time and include a different value for each repeated measure.}

\item{variances}{list of variances for each source of variance}

\item{e_label}{sting label for error variance. defaults to "e"}
}
\value{
returns a matrix
}
\description{
helper function to generate an expected covariance matrix from an ICED measurement structure and vector of variances. Not expected to be called directly, but used within sim_ICED
}
\examples{
struc <- data.frame(time = c("T1", "T2", "T3", "T4"),
day = c("day1","day1","day2","day2"),
session = c("ses1", "ses1","ses2", "ses3"))
 
str2cov(struc,
list(time = 10,
     day = 2,
     session = 1,
     e = 3))

}
