% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_normalize}
\alias{cpp_normalize}
\title{Matrix Normalization}
\arguments{
\item{mat}{a finite NumericMatrix.}

\item{input_range}{a finite NumericVector, sets the range of the input intensity values. Values outside this range are clipped. Default is \code{[0.0,4095.0]}.}

\item{full_range}{if \code{'full_range'} is \code{true}, then \code{'input_range'} will be set to \code{[0.0,4095.0]} and \code{'gamma'} forced to \code{1.0}. Default is \code{false}.}

\item{force_range}{if \code{'force_range'} is \code{true}, then \code{'input_range'} will be adjusted to \code{'mat'} range in \code{[-4095.0, +inf]} and \code{'gamma'} forced to \code{1.0}. Default is \code{false}.\cr
Note that this parameter takes the precedence over \code{'input_range'} and \code{'full_range'}.}

\item{gamma}{correction. Default is \code{1.0}, for no correction.}
}
\description{
Normalizes a finite matrix to [0,1]
}
\keyword{internal}
