% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redefine_utils.R
\name{split_feat}
\alias{split_feat}
\title{IFC_features_def Definition Splitting}
\usage{
split_feat(
  features_def,
  all_names = names(features_def),
  alt_names = NULL,
  m_names = sprintf("M\%02i", 1:12),
  i_names = sprintf("Ch\%02i", 1:12),
  comb_operators = c("+", "-", "*", "/", "(", ")", "ABS", "COS", "SIN", "SQR", "SQRT"),
  extr_operators = c("true", "false", "True", "False"),
  split = "|",
  force = FALSE
)
}
\arguments{
\item{features_def}{an `IFC_features_def` object or a list containing features definition. Default is missing.}

\item{all_names}{the names of all allowed names.}

\item{alt_names}{vector of same length as \code{'all_names'} to use for substitution. It can be used to speed up the process.}

\item{m_names}{names of masks.}

\item{i_names}{names of images.}

\item{comb_operators}{operators used for combined features. Default is \code{c("+", "-", "*", "/", "(", ")", "ABS", "COS", "SIN", "SQR", "SQRT")}.}

\item{extr_operators}{operators used for non combined features. Default is \code{c("true", "false", "True", "False")}.
Those will be added to \code{'m_names'}, \code{'i_names'} and all possible features names (as given by the \code{getFromNamespace("featureIFC", "IFC")()}).}

\item{split}{string used for splitting. Default is \code{"|"}.}

\item{force}{whether to force splitting even if \code{'split'} is detected.}
}
\value{
an `IFC_features_def` object, or a list containing features definition
}
\description{
Helper to split a features definitions within IFC_features_def.
}
\keyword{internal}
