% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irt_m.R
\name{irt_m}
\alias{irt_m}
\title{irt_m}
\usage{
irt_m(
  Y_in,
  d,
  M_matrix = NULL,
  nburn = 1000,
  nsamp = 1000,
  thin = 1,
  learn_loadings = FALSE
)
}
\arguments{
\item{Y_in}{a N x K matrix of responses given by N respondents to K items. Can contain missing values. Column names should match first column in M_matrix.}

\item{d}{an integer specifying the number of latent dimensions.}

\item{M_matrix}{a K x (d+1) matrix of theoretical codings used to constrain IRT-M  (default=NULL). First column should match column names in Y_in.}

\item{nburn}{an integer specifying the number of burn-in MCMC iterations.}

\item{nsamp}{an integer specifying the number of sampling MCMC iterations.}

\item{thin}{an integer specifying the number of thinning MCMC samples.}

\item{learn_loadings}{a Boolean specifying whether a covariance matrix for the latent loadings should be learned, instead of the default covariance matrix for latent dimensions.}
}
\value{
A list containing the following components:
\item{lambda}{An array of dimension (K x d x nsamp/thin) containing posterior samples of item discrimination parameters.}
\item{b}{A matrix of dimension (K x nsamp/thin) containing posterior samples of item difficulty parameters.}
\item{theta}{An array of dimension (N x d x nsamp/thin) containing posterior samples of respondent latent trait values.}
\item{Sigma}{An array of dimension (d x d x nsamp/thin) containing posterior samples of the covariance matrix of latent traits (only if learn_Sigma=TRUE).}
\item{Omega}{An array of dimension (d x d x nsamp/thin) containing posterior samples of the covariance matrix of item loadings (only if learn_Omega=TRUE).}
}
\description{
This function is a wrapper to enable easier use of the IRT-M model in M_constrained_irt.
It takes as input two data frames: a N x K data frame, and a K x (1+d) M-matrix.
The first column of the M-matrix should contain item identifiers that match the K column headers in
the N x K data frame. If they do not match, the wrapper exits with an error.
The wrapper computes anchors, Y_all (merged data and anchors), and a list of diagonal M-Matrices.
The second two are used as inputs to M_constrained_irt, which runs the sampler. Also used as input are
nburn (Default = 10^3), nsamp (Default = 10^3), thin (Default = 1), and
learn_loadings (Default = FALSE). This last one defaults to having the sampler learn factor covariances.
If set to true, it will learn loading covariances instead.
Finally, the wrapper removes the anchors and returns an irt list.
}
