% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISCA_random_assignments.R
\name{ISCA_random_assignments}
\alias{ISCA_random_assignments}
\title{ISCA Random Assignments per Subgroup}
\usage{
ISCA_random_assignments(
  data,
  filter,
  majority_group,
  minority_group,
  cluster_vars,
  fuzzifier = 1.5,
  n_clusters,
  draws = 500
)
}
\arguments{
\item{data}{A dataset containing all relevant variables}

\item{filter}{Specification of the variable name that contains information on majority / minority status.}

\item{majority_group}{Specification of the value within the variable specified in the previous filter-argument indicating majority status. This could be either a numeric value or a character string.}

\item{minority_group}{specification of the value(s) indicating minority status in the filter variable. This could be either a numeric value or a character string. It can be one single minority group or a vector of several minority groups.}

\item{cluster_vars}{Vector specifying the variables that should be used to create the clusters.}

\item{fuzzifier}{The fuzzifier is a value larger than 1 determining the extent of overlap between clusters. A value of 1 effectively makes fuzzy c-means equivalent to hard k-means. The default is 1.5.}

\item{n_clusters}{Specification of the number of clusters to be created.}

\item{draws}{Specification of the number of probabilistic draws. If not specified, the default is 500.}
}
\value{
The output is a dataframe with all original variables and a new column for every draw, each containing one random assignment. This dataframe is the foundation of the subsequent functions in the ISCA package.
}
\description{
Function that calculates membership scores for each subgroup and assigns a cluster for a number of random draws.
}
\examples{
data(sim_data)
ISCA_step1 <- ISCA_random_assignments(data=sim_data,
filter=native, majority_group=1, minority_group=c(0), 
fuzzifier = 1.5, n_clusters=4, draws=5, 
cluster_vars= c("female", "age", "education", "income"));
}
