% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVC.R
\name{IVCCA}
\alias{IVCCA}
\title{Integrated Variance Correlation with Discrete Response Variable}
\usage{
IVCCA(y, x, K)
}
\arguments{
\item{y}{is the categorical response vector}

\item{x}{is a numeric vector}

\item{K}{is the number of quantile levels}
}
\value{
The value of the corresponding sample statistic
}
\description{
This function is used to calculate the integrated variance correlation between a discrete response variable and a continuous random variable
}
\examples{
n=100
y=sample(rep(1:3), n, replace = TRUE, prob = c(1/3,1/3,1/3))
x=c()
for(i in 1:n){
 x[i]=rnorm(1,mean=2*y[i],sd=1)
}

IVCCA(y,x,K=5)
}
