% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmCluster.R
\name{ImCluster}
\alias{ImCluster}
\title{Efficiency of Cluster Sampling for Crop Surveys}
\usage{
ImCluster(x, N = NULL)
}
\arguments{
\item{x}{Datasets}

\item{N}{Number of clusters}
}
\value{
\itemize{
  \item results: Results
}
}
\description{
Efficiency of Cluster Sampling for Crop Surveys
}
\examples{
N_clusters <- 105
orchards_per_cluster <- 4
data <- matrix(rnorm(N_clusters * orchards_per_cluster), nrow = orchards_per_cluster, byrow = TRUE)
colnames(data) <- paste0("Cluster_", 1:N_clusters)
demo_data <- data.frame(data)
result_imcluster <- ImCluster(demo_data, N_clusters)

}
\references{
\itemize{
\item Iqbal, J. M., Faizan, D and  Mansha,  G. (2018) . A Review on the Recent Development on the Cluster Sampling. Biostatistics and Biometrics.  5(5): 555673. DOI: 10.19080/BBOAJ.2018.05.555673
}
}
