% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INFL.core_dw.R
\name{INFL.core_dw}
\alias{INFL.core_dw}
\title{Computes the double weighted core inflation}
\usage{
INFL.core_dw(infl.var, subits.var, weights, wind = 12)
}
\arguments{
\item{infl.var}{A \code{ts} object. The inflation index variation.}

\item{subits.var}{A \code{ts}. Subitems' variation.}

\item{weights}{A \code{ts}. Weights corresponding to each subitem.}

\item{wind}{An \code{integer}. The volatility's window size.}
}
\value{
A \code{ts} object.
}
\description{
Computes the double weighted core inflation
}
\examples{
ipca <- Inflation::ipca_item
nuc <- Inflation::INFL.core_dw(ipca$ipca_index, ipca$ipca_ts, ipca$weights_ts, wind = 12)
}
\keyword{core}
\keyword{weight}
