% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{caldist}
\alias{caldist}
\title{Calculate calibrated distribution}
\usage{
caldist(
  age,
  error,
  cc = 1,
  postbomb = FALSE,
  yrsteps = FALSE,
  threshold = 0.001,
  calibt = FALSE,
  BCAD = FALSE,
  rule = 1,
  ccdir = NULL
)
}
\arguments{
\item{age}{Uncalibrated radiocarbon age}

\item{error}{Lab error of the radiocarbon age}

\item{cc}{Calibration curve to use. Defaults to IntCal20 (\code{cc=1}).}

\item{postbomb}{Whether or not to use a postbomb curve. Required for negative radiocarbon ages.}

\item{yrsteps}{Steps to use for interpolation. Defaults to the cal BP steps in the calibration curve}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=1e-6}.}

\item{calibt}{Use the student-t distribution as alternative to the normal distribution. Requires 2 parameters, e.g., \code{calibt=c(3,4)}, defaults to FALSE.}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}

\item{rule}{Which extrapolation rule to use. Defaults to \code{rule=1} which returns NAs.}

\item{ccdir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{ccdir="curves"}.}
}
\description{
Calculate the calibrated distribution of a radiocarbon date.
}
\examples{
calib <- caldist(130,20)
plot(calib, type="l")
postbomb <- caldist(-3030, 20, "nh1", BCAD=TRUE)
}
