% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterVA5.plot.R
\name{CSMF5}
\alias{CSMF5}
\title{Summarize and plot a population level distribution of va probabilities.}
\usage{
CSMF5(
  va,
  top.aggregate = NULL,
  InterVA.rule = FALSE,
  noplot = FALSE,
  title = "Top CSMF Distribution",
  type = "bar",
  top.plot = 10,
  return.barplot = FALSE,
  min.prob = 0,
  ...
)
}
\arguments{
\item{va}{The list of va object to summarize.}

\item{top.aggregate}{Integer indicating how many causes from the top need to go into
summary. The rest of the probabilities goes into an extra category
"Undetermined".  When set to NULL, default is all causes to be considered.
This is only used when \code{InterVA.rule} set to "FALSE".}

\item{InterVA.rule}{If it is set to "TRUE", only the top 3 causes reported by
InterVA5 is calculated into CSMF as in InterVA5. The rest of probabilities
goes into an extra category "Undetermined". Default set to "FALSE".}

\item{noplot}{A logical value indicating whether the plot will be shown. If
it is set to "TRUE", only the CSMF will be returned.}

\item{title}{A character string for the title of the CSMF plot.}

\item{type}{An indicator of the type of chart to plot.  "pie" for pie chart;
"bar" for bar chart.}

\item{top.plot}{the maximum number of causes to plot in bar plot}

\item{return.barplot}{A logical indicating if the (barplot) ggplot() object
should be returned (instead of printed).  Default value is FALSE.}

\item{min.prob}{The minimum probability that is to be plotted in bar chart,
or to be labeled in pie chart.}

\item{...}{Arguments to be passed to/from graphic function
\code{\link[graphics]{barplot}}, \code{\link[graphics]{pie}}, and more
graphical paramters (see \code{\link[graphics]{par}}). They will affect the
main title, size and font of labels, and the radius of the pie chart.}
}
\value{
\item{dist.cod}{The population probability of CODs.}
}
\description{
The function takes input of a list of va object and produces a summary plot
for the population distribution.
}
\examples{

\dontrun{
data(RandomVA5)
# only fit first 20 observations for a quick illustration
RandomVA5 <- RandomVA5[1:20, ]

sample.output <- InterVA5(RandomVA5, HIV = "h", Malaria = "v", write = FALSE, 
       directory = tempdir(), filename = "VA5_result", output = "extended", 
       append = FALSE)

## Get CSMF by considering only top 3 causes reported by InterVA5.
## This is equivalent to using CSMF.interVA5() command Note that
## it's different from using all top 3 causses, since they may not
## all be reported
CSMF.summary <- CSMF5(sample.output, InterVA.rule = TRUE,
   noplot = TRUE)

## Population level summary using pie chart
CSMF.summary2 <- CSMF5(sample.output, type = "pie",
 min.prob = 0.01, title = "population COD distribution using pie chart",
 clockwise = FALSE, radius = 0.7, cex = 0.7, cex.main = 0.8)

## Population level summary using bar chart
CSMF.summary3 <- CSMF5(sample.output, type = "bar",
  min.prob = 0.01, title = "population COD distribution using bar chart",
  cex.main = 1)
CSMF.summary4 <- CSMF5(sample.output, type = "bar",
  top.plot = 5, title = "Top 5 population COD distribution",
  cex.main = 1)
}

}
\seealso{
\code{\link{CSMF.interVA5}}
}
\author{
Jason Thomas, Zehang LI, Tyler McCormick, Sam Clark
}
\keyword{interVA}
