% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-c.R
\name{c}
\alias{c}
\alias{c,IntervalDataOrIntervalList-method}
\title{Combine \code{IntervalData} and \code{IntervalList} objects}
\usage{
\S4method{c}{IntervalDataOrIntervalList}(x, ...)
}
\arguments{
\item{x}{A single nonempty compact real interval or a unique list of
of this family stored as an \code{IntervalData} object or an
\code{IntervalList} instance, respectively.}

\item{...}{Additional single nonempty compact real intervals or lists of
intervals of this family stored as \code{IntervalData} or
\code{IntervalList} instances, respectively.}
}
\value{
This function returns the list of intervals obtained after the combination
of the given interval-valued elements saved as an\code{IntervalList} object.
}
\description{
This function allows to combine single intervals and lists of intervals,
that is, \code{IntervalData} and \code{IntervalList} objects, and then
store the attained result as an \code{IntervalList} instance.
}
\examples{
## Combine 'IntervalData' objects
i1 <- IntervalData(0, 1)
i2 <- IntervalData(0, 2)
list1 <- c(i1, i2)
list1

## Combine 'IntervalList' objects
list2 <- c(list1, list1)
list2

## Combine both 'IntervalData' and 'IntervalList' objects
list3 <- c(i1, list1)
list3
list4 <- c(list1, i1)
list4
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
