% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{ItoPearsonCorrelation}
\alias{ItoPearsonCorrelation}
\title{Calculate the equivalence r from the I percentile in the I-Null Distribution.}
\usage{
ItoPearsonCorrelation(vI, n, medianCenter = TRUE)
}
\arguments{
\item{vI}{the vector obtained by resamplingI.}

\item{n}{sample size}

\item{medianCenter}{to center all the values to the median. The defaul value is TRUE}
}
\value{
a list with r correlation equivalence and the rectified vector
}
\description{
\code{ItoPearsonCorrelation} It calculates the Null distribution of I and determine what is the percentile of the real value of I,
then It calculates the inverse of the Normal Distribution(qnorm) to obtain the value of R to which this percentile belongs to.
}
\examples{
fileInput <- system.file("testdata", "chen.csv", package="Irescale")
data <- loadFile(fileInput)
distM<-calculateEuclideanDistance(data$data)
vI<-resamplingI(distM,data$varOfInterest,n = 1000)
rectifiedI<- ItoPearsonCorrelation(vI, length(data))
}
