% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{plotHistogramOverlayCorrelation}
\alias{plotHistogramOverlayCorrelation}
\title{Creates an overlay of the histogram of the data and the theorical normal distribution.}
\usage{
plotHistogramOverlayCorrelation(originalVec, vec, I, n, bins = 50,
  main = "Histogram")
}
\arguments{
\item{originalVec}{The original vector of I, it should be sorted.}

\item{vec}{the vector to plot.}

\item{I}{the value of I to plot}

\item{n}{number of observations in the sample.}

\item{bins}{the number of bins for the histogram, The default value is 30.}

\item{main}{the title of the histogram, The default value is "Histogram".}
}
\description{
\code{plotHistogramOverlayCorrelation} Overlays the histogram and the theorical normal distribution.
}
\examples{
inputFileName<-system.file("testdata", "chen.csv", package="Irescale")
input<-loadFile(inputFileName)
distM<-calculateEuclideanDistance(input$data)
I<-calculateMoranI(distM = distM,varOfInterest = input$varOfInterest)
originalI<-resamplingI(distM, input$varOfInterest)
correlationI<-ItoPearsonCorrelation(originalI,length(input$varOfInterest))
plotHistogramOverlayCorrelation(originalI,correlationI,I,length(input$varOfInterest))
}
