% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{standardize}
\alias{standardize}
\title{Standardize the input vector}
\usage{
standardize(vectorI, W)
}
\arguments{
\item{vectorI}{vector to be standardized.}

\item{W}{weighed distance matrix}
}
\value{
z values
}
\description{
\code{standardize} Calculates the z-values of the input vector.
#'\deqn{
z = \frac{vectorI - meanI}{\sqrt{varI}}
}
}
\examples{
W<-matrix(runif(100, min=0, max=1),nrow=10,ncol=10)
vectorI<-runif(10, min=0, max=1)
standardize(vectorI,W)
}
