% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_support.R
\name{predict.pspfit}
\alias{predict.pspfit}
\title{Predict function for \code{psNormal}, \code{psBinomial}, \code{psPoisson}}
\usage{
\method{predict}{pspfit}(object, ..., x, type = "mu")
}
\arguments{
\item{object}{an object using \code{psNormal}, \code{psBinomial}, or \code{psPoisson} .}

\item{...}{other parameters.}

\item{x}{a scalar or vector of arbitrary \code{x} locations for
desired prediction.}

\item{type}{the mean value \code{type = "mu"} (default) or linear predictor
\code{type = "eta"}.}
}
\value{
\item{pred}{the estimated mean (inverse link function) (default)
or the linear predictor prediction with \code{type =
"eta"}, at arbitary \code{x} locations.}
}
\description{
Prediction function which returns both linear
predictor and inverse link predictions at arbitrary data locations
(using \code{psNormal}, \code{psBinomial}, \code{psPoisson} with \code{class pspfit}).
}
\examples{
library(JOPS)
library(boot)

# Extract the data
Count <- hist(boot::coal$date, breaks = c(1851:1963), plot = FALSE)$counts
Year <- c(1851:1962)
xl <- min(Year)
xr <- max(Year)

# Poisson smoothing
nseg <- 20
bdeg <- 3
fit1 <- psPoisson(Year, Count, xl, xr, nseg, bdeg, pord = 2, lambda = 1)
names(fit1)
plot(fit1, xlab = "Year", ylab = "Count", se = 2)
predict(fit1, x = fit1$x[1:5])
predict(fit1, x = fit1$x[1:5], type = "eta")
}
\references{
Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers and Brian Marx
}
