
#'
#' PCLR_Train
#' 
#' PCLR_Train is the train set of the PCR model. It consists of Age, Cluster1, 
#' MeanDNE.Apex, TotalDNE.TotalPolygonFaces, MedianDNE.Whole, IQRDNE.Whole and 
#' MeanDNE.Convex. The number of rows is 699.
#' 
#' 
#' 
#' @export
#' 
PCLR_Train<-{
  Age <- c(21, 71, 71, 72, 72, 78, 78, 87, 72, 72, 71, 71, 80, 79, 79, 77, 56, 68, 70, 70, 67, 73, 73, 75, 33, 81, 81, 48, 48, 25, 78, 76, 93, 93, 60, 60, 75, 75, 79, 79, 70, 70, 79, 79, 68, 68, 68, 46, 46, 72, 68, 68, 80, 80, 52, 52, 76, 76, 49, 49, 20, 35, 35, 39, 39, 85, 69, 68, 32, 77, 77, 80, 45, 75, 75, 75, 29, 73, 73, 48, 86, 79, 85, 57, 57, 51, 51, 93, 93, 76, 72, 62, 51, 51, 69, 69, 65, 68, 68, 89, 56, 75, 75, 68, 68, 54, 31, 31, 77, 39, 47, 47, 25, 25, 28, 56, 56, 34, 34, 61, 55, 33, 33, 23, 23, 47, 47, 38, 26, 26, 29, 20, 20, 66, 66, 89, 89, 72, 72, 22, 94, 68, 42, 42, 69, 32, 26, 69, 67, 67, 34, 34, 70, 70, 33, 33, 87, 87, 25, 35, 35, 79, 79, 20, 35, 35, 22, 76, 25, 
           25, 23, 23, 26, 26, 45, 45, 28, 28, 46, 46, 46, 20, 20, 41, 41, 37, 48, 27, 27, 75, 75, 72, 72, 62, 62, 46, 46, 65, 23, 23, 72, 72, 80, 65, 75, 85, 49, 55, 64, 64, 40, 59, 58, 64, 70, 45, 45, 52, 52, 20, 72, 72, 69, 69, 76, 76, 43, 60, 28, 60, 28, 35, 58, 62, 58, 47, 47, 79, 79, 52, 73, 73, 52, 52, 40, 40, 74, 66, 74, 50, 50, 29, 29, 57, 50, 82, 82, 42, 57, 60, 60, 70, 66, 66, 78, 78, 59, 59, 69, 50, 69, 84, 56, 56, 65, 77, 75, 70, 27, 27, 53, 83, 54, 83, 54, 47, 47, 83, 83, 61, 61, 68, 68, 68, 60, 68, 63, 52, 75, 75, 65, 65, 71, 71, 69, 80, 80, 31, 60, 60, 20, 20, 41, 41, 78, 69, 30, 30, 54, 75, 44, 57, 58, 57, 69, 69, 75, 52, 29, 29, 82, 63, 63, 57, 83, 35, 35, 65, 38, 38, 53, 53, 39, 51, 65, 65, 67, 62, 27, 27, 65, 27, 68, 65, 65, 54, 54, 57, 57, 33, 33, 72, 72, 31, 31, 69, 69, 72, 52, 70, 59, 65, 56, 54, 54, 84, 84, 56, 74, 74, 50, 50, 54, 54, 59, 59, 59, 59, 43, 43, 32, 50, 67, 67, 75, 49, 49, 61, 61, 31, 31, 89, 56, 56, 56, 56, 46, 34, 46, 34, 57, 57, 62, 33, 33, 68, 53, 39, 39, 63, 38, 38, 50, 62, 68, 68, 66, 66, 59, 59, 52, 48, 48, 43, 47, 47, 45, 45, 70, 25, 70, 25, 68, 68, 55, 28, 28, 54, 54, 53, 57, 57, 35, 51, 51, 26, 26, 39, 39, 71, 71, 44, 44, 25, 25, 22, 45, 45, 23, 23, 28, 28, 32, 32, 30, 30, 49, 64, 64, 62, 49, 35, 70, 30, 66, 66, 29, 29, 46, 38, 38, 71, 71, 48, 48, 67, 67, 67, 68, 68, 60, 45, 45, 39, 39, 49, 44, 26, 26, 44, 34, 65, 65, 80, 80, 60, 48, 64, 43, 68, 65, 63, 37, 37, 63, 63, 89, 89, 83, 83, 43, 43, 35, 35, 90, 90, 67, 94, 94, 46, 81, 81, 24, 92, 21, 21, 43, 49, 76, 76, 60, 32, 32, 38, 38, 37, 
           37, 33, 33, 74, 86, 86, 68, 78, 83, 83, 30, 96, 96, 47, 39, 39, 75, 75, 96, 96, 49, 49, 84, 81, 83, 83, 88, 74, 74, 30, 49, 52, 52, 61, 78, 78, 85, 77, 77, 60, 60, 42, 76, 85, 85, 45, 81, 81, 74, 89, 44, 96, 96, 79, 85, 85, 68, 78, 62, 36, 36, 92, 68, 68, 83, 62, 88, 80, 47, 47, 70, 70, 67, 72, 72, 60, 83, 60, 79, 79, 69, 69, 60, 51, 82, 81, 81, 67, 67, 85, 80, 80, 55, 55, 66, 66, 96, 96, 61, 61, 85, 85, 50, 50, 86, 48, 48, 61, 61, 85, 85, 74, 71, 71, 88, 88, 75, 75, 76, 82, 66, 68, 68, 68, 88, 88, 44, 44, 79, 58, 58, 93, 87, 65, 65, 49, 49, 76, 76, 55, 55, 55, 83) 
  Cluster1 <- c(1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1, 2, 1, 1, 2, 2, 2, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 2, 1, 2, 2, 1, 1, 2, 2, 2, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 2, 1, 1, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 
                2, 2, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 1, 1, 2, 2, 2, 2, 1, 1, 2, 2, 1, 1, 1, 2)
  
  MeanDNE.Apex <- c(0.026252, 0.037500, 0.036605, 0.039641, 0.033187, 0.039875, 0.036556, 0.038596, 0.030157, 0.038653, 0.043363, 0.037548, 0.040167, 0.036915, 0.044159, 0.026329, 0.034419, 0.038635, 0.041455, 0.037373, 0.048303, 0.039402, 0.034611, 0.036226, 0.028308, 0.054399, 0.037933, 0.030865, 0.028962, 0.024660, 0.037293, 0.036599, 0.040052, 0.039781, 0.037117, 0.028459, 0.045117, 0.034535, 0.038681, 0.042979, 0.037310, 0.043667, 0.040513, 0.041285, 0.033705, 0.041119, 0.043076, 0.031265, 0.032797, 0.037797, 0.033860, 0.034865, 0.036645, 0.032415, 0.037685, 0.027353, 0.037676, 0.034756, 0.027067, 0.030197, 0.029207, 0.032765, 0.031610, 0.027261, 0.025692, 0.036169, 0.036813, 0.031711, 0.031010, 0.038272, 0.036163, 0.039968, 0.025552, 0.036443, 0.037867, 0.035316, 0.033962, 0.040341, 0.042902, 0.036839, 0.046001, 0.040684, 0.039771, 0.033859, 0.027534, 0.029470, 0.034135, 0.049248, 0.040434, 0.038338, 0.037826, 0.037217, 0.033341, 0.031366, 0.030387, 0.042356, 0.034901, 0.036251, 0.035835, 0.048558, 0.033709, 0.032198, 0.037207, 0.042720, 0.037589, 0.034267, 0.030477, 0.031741, 0.036012, 0.035826, 0.028629, 0.031604, 0.027411, 
                    0.023636, 0.028862, 0.033071, 0.040110, 0.032443, 0.034857, 0.033771, 0.031168, 0.038296, 0.032553, 0.035445, 0.027494, 0.031393, 0.026558, 0.035365, 0.024281, 0.023683, 0.031685, 0.027524, 0.022206, 0.037741, 0.036623, 0.039293, 0.040294, 0.029836, 0.032163, 0.028935, 0.047235, 0.033854, 0.027570, 0.033375, 0.032137, 0.033609, 0.030917, 0.038655, 0.039131, 0.035849, 0.025555, 0.027690, 0.040131, 0.040704, 0.026102, 0.027938, 0.042649, 0.040018, 0.030900, 0.025552, 0.028897, 0.044165, 0.045101, 0.025058, 0.032037, 0.032519, 0.026281, 0.047362, 0.025893, 0.023893, 0.030758, 0.032572, 0.023789, 0.037636, 0.036372, 0.037386, 0.026274, 0.027844, 0.036103, 0.030258, 0.031288, 0.032122, 0.026077, 0.027282, 0.024191, 0.030039, 0.032473, 0.025483, 0.031911, 0.042017, 0.040552, 0.031426, 0.038136, 0.040049, 0.034451, 0.037183, 0.031317, 0.041740, 0.031714, 0.026987, 0.034797, 0.041185, 0.041252, 0.036428, 0.035762, 0.036596, 0.032541, 0.033169, 0.034372, 0.037328, 0.027410, 0.039987, 0.036237, 0.030663, 0.032045, 0.029582, 0.025469, 0.038985, 0.027303, 0.025520, 0.038712, 0.032570, 0.032714, 0.041696, 0.032322, 0.037361, 0.027557, 0.042304, 0.033506, 0.033303, 0.031679, 0.025998, 0.037428, 0.033681, 0.029428, 0.033633, 0.033624, 0.034773, 0.042030, 0.031467, 0.039991, 0.040149, 0.031296, 0.030683, 0.031538, 0.029082, 0.044775, 0.033904, 0.032565, 0.037080, 0.038957, 0.032373, 0.032642, 0.034006, 0.037456, 0.040169, 0.035279, 0.031108, 0.030727, 0.032861, 0.030692, 0.038114, 0.035489, 0.036970, 0.039742, 0.036101, 0.027799, 0.033488, 0.036178, 0.035772, 0.037214, 0.036548, 0.030517, 0.031819, 0.034652, 0.034925, 0.039672, 0.039604, 0.026528, 0.024094, 0.035810, 0.035453, 0.032404, 0.034457, 0.034363, 0.030683, 0.032111, 0.040163, 0.040587, 0.035655, 0.035693, 0.040303, 0.039409, 0.035292, 0.032633, 0.032229, 0.039901, 0.037341, 0.039104, 0.034621, 0.039901, 0.035788, 0.034514, 0.044014, 0.039842, 0.035346, 0.039910, 0.029960, 0.035603, 0.039680, 0.025430, 0.030452, 0.030934, 0.029881, 0.044180, 0.037292, 0.031450, 0.025148, 0.037449, 0.039048, 0.030998, 0.034242, 0.028190, 0.035714, 0.034271, 0.030377, 0.040332, 
                    0.032884, 0.036168, 0.024885, 0.039432, 0.036622, 0.037745, 0.034290, 0.036086, 0.026843, 0.028554, 0.026415, 0.032292, 0.036010, 0.030936, 0.030239, 0.035889, 0.033619, 0.033017, 0.036335, 0.031837, 0.037160, 0.031279, 0.024990, 0.040095, 0.024147, 0.037828, 0.036318, 0.032117, 0.031934, 0.028348, 0.037000, 0.027988, 0.027837, 0.028892, 0.033590, 0.038600, 0.028867, 0.024474, 0.037310, 0.034014, 0.035686, 0.035795, 0.039419, 0.035210, 0.040503, 0.030866, 0.032610, 0.030581, 0.046057, 0.032051, 0.035938, 0.033313, 0.030557, 0.026772, 0.034346, 0.036165, 0.033863, 0.033023, 0.039125, 0.035459, 0.035165, 0.032630, 0.031756, 0.030291, 0.034257, 0.031361, 0.035356, 0.030689, 0.031145, 0.033995, 0.036065, 0.034895, 0.024868, 0.027001, 0.042148, 0.035682, 0.034128, 0.032873, 0.034369, 0.027001, 0.026086, 0.032679, 0.027098, 0.027548, 0.035381, 0.028955, 0.029083, 0.029867, 0.037057, 0.028585, 0.027014, 0.031029, 0.032824, 0.030532, 0.030120, 0.033895, 0.037102, 0.034572, 0.030727, 0.034632, 0.038422, 0.031631, 0.037187, 0.028169, 0.028942, 0.031995, 0.027911, 0.031634, 0.030715, 0.029029, 0.040849, 0.037811, 0.028102, 0.032873, 0.023709, 0.037172, 0.030545, 0.032418, 0.029458, 0.026863, 0.027860, 0.035114, 0.033761, 0.036739, 0.031246, 0.029918, 0.031173, 0.032883, 0.029700, 0.029067, 0.032089, 0.030446, 0.032644, 0.033050, 0.032542, 0.031894, 0.040234, 0.032928, 0.030630, 0.033018, 0.027989, 0.025887, 0.022913, 0.029748, 0.026037, 0.033003, 0.031608, 0.031978, 0.026694, 0.036911, 0.041933, 0.038028, 0.031245, 0.038384, 0.029156, 0.035921, 0.029884, 0.032159, 0.041832, 0.029855, 0.032567, 0.033151, 0.031540, 0.034134, 0.037540, 0.041991, 0.033914, 0.031701, 0.034582, 0.042660, 0.038354, 0.031715, 0.034164, 0.039318, 0.031230, 0.032165, 0.029665, 0.029109, 0.030109, 0.036881, 0.028387, 0.023200, 0.034672, 0.034185, 0.032711, 0.033994, 0.037911, 0.040013, 0.037992, 0.036382, 0.029660, 0.026143, 0.031332, 0.036066, 0.040075, 0.031522, 0.026031, 0.031707, 0.035978, 0.047798, 0.048041, 0.040829, 0.039435, 0.033651, 0.031928, 0.031356, 0.032418, 0.051794, 0.032669, 0.034320, 0.045232, 0.043656, 0.034522, 0.032132, 0.036967, 0.026203, 0.047955, 0.022237, 0.043581, 0.029050, 0.027588, 0.038353, 0.042238, 0.033049, 
                    0.031530, 0.031530, 0.025781, 0.026930, 0.029095, 0.026887, 0.030296, 0.029691, 0.039690, 0.040800, 0.037693, 0.035623, 0.033199, 0.042810, 0.033255, 0.032098, 0.062042, 0.051777, 0.027355, 0.035712, 0.029360, 0.044737, 0.040157, 0.038122, 0.044811, 0.037544, 0.041592, 0.036075, 0.042318, 0.043157, 0.034497, 0.044799, 0.036302, 0.038958, 0.032236, 0.029351, 0.033089, 0.039012, 0.029056, 0.037924, 0.036937, 0.035093, 0.040154, 0.033745, 0.035765, 0.024141, 0.037185, 0.036827, 0.044536, 0.033112, 0.030558, 0.039947, 0.037581, 0.039436, 0.053978, 0.036780, 0.049990, 0.044861, 0.037285, 0.037486, 0.038434, 0.041167, 0.039559, 0.035106, 0.026466, 0.035623, 0.036466, 0.030149, 0.037486, 0.036758, 0.028984, 0.038320, 0.042604, 0.032728, 0.029514, 0.033232, 0.033232, 0.040474, 0.040142, 0.039972, 0.036632, 0.041176, 0.036962, 0.039036, 0.043504, 0.036411, 0.036402, 0.036899, 0.026881, 0.036783, 0.044721, 0.041588, 0.042449, 0.035886, 0.035170, 0.046140, 0.036742, 0.032180, 0.030701, 0.030504, 0.036479, 0.040876, 0.043761, 0.034099, 0.036033, 0.049909, 0.039543, 0.033656, 0.029978, 0.046958, 0.034437, 0.035203, 0.037771, 0.032967, 0.046398, 0.057150, 0.038590, 0.038108, 0.040880, 0.046040, 0.040901, 0.035161, 0.037959, 0.035913, 0.036657, 0.032937, 0.042849, 0.037736, 0.041173, 0.043943, 0.043082, 0.036509, 0.027285, 0.049667, 0.031973, 0.029564, 0.036164, 0.045553, 0.034287, 0.036300, 0.035316, 0.032289, 0.041051, 0.037271, 0.029496, 0.034228, 0.030283, 0.038832)
  
  TotalDNE.TotalPolygonFaces <- c(0.020791, 0.025182, 0.022533, 0.028801, 0.029517, 0.024517, 0.026235, 0.025195, 0.028578, 0.027106, 0.026717, 0.023180, 0.023626, 0.027568, 0.022099, 0.038190, 0.022448, 0.021462, 0.028718, 0.024106, 0.021462, 0.023750, 0.028202, 0.027648, 0.020585, 0.023000, 0.026724, 0.016475, 0.023661, 0.015720, 0.031587, 0.022577, 0.027798, 0.027348, 0.025894, 0.027085, 0.030688, 0.028520, 0.026925, 0.025104, 0.024481, 0.027370, 0.029350, 0.028471, 0.021948, 0.027318, 0.020853, 0.017495, 0.022849, 0.023588, 0.020716, 0.024999, 0.027665, 0.030594, 0.019395, 0.014926, 0.028390, 0.028915, 0.018255, 0.017240, 0.018490, 0.015563, 0.015824, 0.014684, 0.015986, 0.025537, 0.028484, 0.021464, 0.017533, 0.025392, 0.032416, 0.030067, 0.021180, 0.023457, 0.022241, 0.027213, 0.019136, 0.025209, 0.030258, 0.015882, 0.033949, 0.023517, 0.026184, 0.023979, 0.024064, 0.022986, 0.020092, 0.035271, 0.032218, 0.022428, 0.028285, 
                                  0.019812, 0.019829, 0.019990, 0.025257, 0.021120, 0.028381, 0.020687, 0.026424, 0.040472, 0.026891, 0.019487, 0.030457, 0.023810, 0.023463, 0.017159, 0.018366, 0.016440, 0.032571, 0.016603, 0.022675, 0.015058, 0.015707, 0.018624, 0.019894, 0.023768, 0.027023, 0.015115, 0.015473, 0.022980, 0.025873, 0.015943, 0.017775, 0.016683, 0.016368, 0.020520, 0.024074, 0.019255, 0.011815, 0.014029, 0.013565, 0.017607, 0.014031, 0.026150, 0.028196, 0.029464, 0.032408, 0.027608, 0.025978, 0.016780, 0.051624, 0.026368, 0.019185, 0.016533, 0.025720, 0.014008, 0.014965, 0.020696, 0.028615, 0.028943, 0.021984, 0.017215, 0.026839, 0.025247, 0.017628, 0.016171, 0.027052, 0.030905, 0.013356, 0.020300, 0.016122, 0.028831, 0.024294, 0.018852, 0.014476, 0.013903, 0.016818, 0.027865, 0.016656, 0.015801, 0.016741, 0.022113, 0.018924, 0.027470, 0.021693, 0.020322, 0.018785, 0.017529, 0.017329, 0.021162, 0.016343, 0.014993, 0.015903, 0.019934, 0.016081, 0.014298, 0.023261, 0.014013, 0.015189, 0.021669, 0.022082, 0.030838, 0.022754, 0.028433, 0.021544, 0.021574, 0.022859, 0.020698, 0.012892, 0.016994, 0.031309, 0.027879, 0.023067, 0.029585, 0.033288, 0.029002, 0.018004, 0.022935, 0.022439, 0.021926, 0.018371, 0.023927, 0.022973, 0.026475, 0.030102, 0.023152, 0.015555, 0.022232, 0.019016, 0.018233, 0.023740, 0.021957, 0.027779, 0.021154, 0.027105, 0.032912, 0.015816, 0.030465, 0.023662, 0.023764, 0.023377, 0.022095, 0.028835, 0.027389, 0.026951, 0.017910, 0.024942, 0.034824, 0.023730, 0.023955, 0.022038, 0.035476, 0.018810, 0.023971, 0.019541, 0.016858, 0.028436, 0.023600, 0.021953, 0.021151, 0.021641, 0.016147, 0.015161, 0.027347, 0.016359, 0.030713, 0.024213, 0.018480, 0.027809, 0.030292, 0.021407, 0.029519, 0.021179, 0.024912, 0.027708, 0.029150, 0.028283, 0.028080, 0.024469, 0.017677, 0.020832, 0.027642, 0.019206, 0.022278, 0.026160, 0.029408, 0.030207, 0.026923, 0.020605, 0.012133, 0.015293, 0.022153, 0.021382, 0.031172, 0.026889, 0.019052, 0.019358, 0.028301, 0.030924, 0.026623, 0.027068, 0.023467, 0.027621, 0.026897, 0.024279, 0.019080, 0.027685, 0.024708, 0.027600, 0.024534, 0.024797, 0.028009, 0.029211, 0.029031, 0.023529, 0.026101, 0.029222, 0.015159, 0.019795, 0.019069, 0.012674, 0.017339, 0.014625, 0.023895, 0.029117, 0.023955, 0.018288, 0.017404, 0.023503, 0.028827, 0.017066, 0.024539, 0.016969, 0.024314, 0.034059, 0.029586, 0.029647, 0.017737, 0.017154, 0.018832, 0.031646, 0.026276, 0.028637, 0.019158, 0.029836, 0.017045, 0.021232, 0.023923, 0.015161, 0.017387, 0.017610, 0.018174, 0.021269, 0.017432, 0.025381, 
                                  0.024570, 0.028516, 0.019677, 0.017644, 0.017589, 0.025123, 0.019831, 0.024114, 0.020291, 0.027859, 0.025536, 0.025183, 0.024685, 0.020979, 0.014506, 0.012970, 0.024447, 0.017729, 0.015829, 0.012575, 0.026831, 0.022845, 0.029017, 0.025664, 0.027359, 0.019877, 0.027512, 0.021358, 0.025500, 0.018457, 0.034255, 0.029270, 0.024506, 0.022691, 0.028292, 0.023309, 0.018602, 0.018700, 0.017267, 0.022776, 0.023205, 0.014093, 0.023460, 0.016874, 0.020788, 0.020339, 0.021789, 0.024748, 0.022017, 0.026234, 0.024130, 0.019246, 0.020398, 0.025008, 0.017502, 0.019133, 0.032259, 0.027444, 0.024012, 0.017856, 0.019727, 0.022260, 0.016819, 0.024002, 0.018911, 0.021659, 0.016481, 0.025724, 0.018719, 0.017615, 0.024146, 0.020012, 0.017029, 0.017380, 0.019668, 0.016834, 0.023203, 0.020765, 0.021467, 0.026874, 0.028915, 0.022991, 0.021121, 0.028854, 0.025778, 0.022723, 0.021279, 0.022555, 0.023666, 0.018675, 0.021798, 0.013154, 0.024713, 0.021177, 0.017770, 0.026204, 0.019341, 0.028046, 0.029311, 0.026572, 0.015373, 0.014017, 0.024763, 0.021255, 0.027633, 0.020865, 0.023778, 0.016583, 0.022469, 0.025362, 0.017710, 0.016536, 0.018634, 0.019085, 0.025674, 0.024837, 0.020796, 0.019477, 0.014735, 0.014383, 0.015875, 0.023354, 0.023226, 0.015291, 0.016611, 0.017618, 0.014803, 0.019165, 0.018494, 0.013252, 0.017931, 0.018205, 0.025587, 0.028021, 0.016197, 0.028824, 0.018256, 0.028813, 0.016549, 0.027443, 0.026930, 0.015325, 0.019138, 0.015748, 0.015094, 0.016291, 0.026472, 0.023888, 0.019109, 0.015378, 0.025039, 0.023746, 0.022958, 0.023837, 0.028673, 0.022783, 0.015155, 0.016275, 0.022125, 0.020630, 0.017625, 0.019501, 0.019715, 0.028166, 0.013766, 0.015169, 0.021112, 0.027979, 0.030020, 0.024564, 0.028106, 0.023281, 0.017670, 0.023869, 0.029179, 0.027233, 0.027417, 0.014527, 0.022463, 0.023854, 0.021716, 0.026089, 0.043325, 0.031367, 0.024230, 0.014647, 0.016219, 0.014741, 0.014094, 0.030046, 0.026917, 0.022804, 0.031232, 0.033175, 0.016549, 0.031397, 0.029319, 0.020456, 0.025401, 0.015049, 0.013086, 0.020938, 0.021606, 0.025073, 0.027642, 0.027101, 0.013179, 0.020920, 0.020899, 0.015805, 0.013807, 0.020750, 0.012287, 0.012495, 0.027305, 0.029922, 0.030035, 0.029103, 0.028199, 0.026735, 0.030712, 0.019410, 0.055677, 0.041837, 
                                  0.022963, 0.019126, 0.016286, 0.024840, 0.025175, 0.026096, 0.028873, 0.020057, 0.024528, 0.032591, 0.032040, 0.025032, 0.026269, 0.026772, 0.025542, 0.026239, 0.019385, 0.021703, 0.022946, 0.023307, 0.021948, 0.027834, 0.030570, 0.029382, 0.031993, 0.042541, 0.027098, 0.027423, 0.016433, 0.023962, 0.024873, 0.030387, 0.021479, 0.027996, 0.023527, 0.022850, 0.032192, 0.023950, 0.026938, 0.032720, 0.029886, 0.031971, 0.027722, 0.036884, 0.024848, 0.021079, 0.021501, 0.018663, 0.024204, 0.024387, 0.025508, 0.019244, 0.022555, 0.027316, 0.023662, 0.016951, 0.016292, 0.029812, 0.020723, 0.025036, 0.021908, 0.021292, 0.018933, 0.045908, 0.020832, 0.029362, 0.029817, 0.027684, 0.026930, 0.020439, 0.025761, 0.023937, 0.027550, 0.041029, 0.021601, 0.025378, 0.031941, 0.021379, 0.023502, 0.024656, 0.022624, 0.024786, 0.018023, 0.032194, 0.032689, 0.026534, 0.023088, 0.025889, 0.032933, 0.027966, 0.025203, 0.029653, 0.026138, 0.025025, 0.025788, 0.020127, 0.029206, 0.029831, 0.029415, 0.027958, 0.023179, 0.032742, 0.027737, 0.029507, 0.027461, 0.022964, 0.029516, 0.020904, 0.028931, 0.025156, 0.024172, 0.029245, 0.031592, 0.015848, 0.015935, 0.033256, 0.032053, 0.019413, 0.025473, 0.028766, 0.023353, 0.025937, 0.023810, 0.022206, 0.028906, 0.028988, 0.021627, 0.021648, 0.022410, 0.027641)
  
  MedianDNE.Whole <- c(0.006122, 0.009500, 0.009602, 0.009062, 0.009682, 0.010760, 0.009255, 0.010630, 0.009672, 0.009656, 0.009153, 0.010622, 0.010486, 0.008911, 0.010627, 0.006286, 0.007732, 0.009186, 0.009131, 0.008973, 0.008879, 0.009657, 0.010167, 0.011046, 0.006338, 0.010110, 0.009074, 0.008484, 0.008482, 0.005815, 0.009153, 0.010271, 0.008477, 0.010476, 0.007885, 0.009658, 0.006965, 0.009045, 0.010418, 0.010050, 0.009569, 0.009827, 0.010780, 0.011018, 0.009627, 0.008271, 0.008648, 0.007068, 0.008103, 0.010288, 0.009636, 0.009114, 0.008953, 0.011680, 0.008237, 0.008571, 0.010552, 0.010755, 0.007938, 0.008040, 0.006395, 0.007012, 0.007009, 0.006547, 0.006779, 0.010628, 0.009700, 0.009601, 0.006062, 0.011415, 0.010194, 0.010763, 0.007102, 0.010431, 0.009760, 0.009207, 0.007174, 0.009747, 0.010353, 0.007609, 0.010858, 0.010644, 0.009733, 0.005606, 0.008164, 0.007118, 0.008168, 0.012494, 0.011785, 0.009762, 0.011956, 0.009006, 0.008724, 0.008782, 0.010748, 0.009131, 0.009680, 0.008547, 0.009166, 0.014599, 0.010516, 0.008084, 0.010355, 0.008992, 0.009678, 0.007540, 0.006107, 0.006118, 0.009590, 0.006911, 0.008381, 0.008379, 
                       0.007271, 0.006846, 0.007453, 0.008541, 0.009798, 0.007498, 0.006354, 0.009399, 0.007851, 0.008001, 0.006465, 0.006221, 0.006920, 0.010835, 0.008104, 0.007153, 0.005901, 0.005805, 0.006060, 0.006885, 0.005906, 0.009666, 0.010898, 0.010800, 0.010800, 0.009706, 0.009744, 0.007137, 0.017802, 0.009571, 0.007258, 0.007548, 0.009716, 0.007412, 0.006654, 0.009001, 0.009122, 0.009558, 0.007931, 0.007791, 0.009531, 0.010642, 0.007348, 0.007110, 0.010474, 0.010434, 0.006107, 0.007102, 0.006536, 0.010739, 0.010689, 0.004745, 0.007577, 0.007640, 0.006068, 0.010519, 0.007225, 0.006945, 0.006745, 0.006393, 0.007221, 0.008370, 0.007516, 0.007084, 0.006052, 0.006661, 0.007486, 0.008101, 0.008055, 0.006879, 0.006101, 0.010705, 0.008456, 0.007181, 0.008108, 0.006430, 0.008475, 0.012092, 0.008864, 0.009136, 0.009136, 0.008414, 0.007097, 0.008189, 0.008443, 0.006656, 0.006427, 0.008212, 0.010751, 0.010061, 0.010553, 0.008791, 0.010463, 0.010670, 0.007610, 0.008791, 0.008151, 0.008806, 0.008924, 0.008794, 0.008791, 0.007639, 0.009244, 0.007493, 0.007097, 0.008891, 0.008247, 0.006114, 0.008771, 0.008609, 0.008915, 0.007397, 0.010283, 0.010725, 0.007277, 0.006490, 0.006108, 0.010405, 0.009522, 0.007197, 0.010861, 0.009134, 0.007909, 0.007993, 0.006388, 0.010382, 0.009568, 0.008519, 0.011090, 0.012600, 0.006487, 0.008539, 0.007608, 0.006752, 0.010219, 0.009560, 0.009130, 0.008162, 0.008151, 0.006892, 0.006685, 0.009377, 0.008492, 0.010791, 0.009425, 0.007649, 0.008645, 0.009745, 0.007856, 0.010097, 0.009573, 0.009134, 0.010774, 0.009691, 0.008588, 0.010042, 0.010042, 0.008546, 0.009130, 0.011763, 0.007637, 0.008649, 0.009619, 0.010758, 0.009515, 0.009282, 0.006378, 0.006410, 0.008819, 0.010201, 0.008846, 0.011926, 0.007573, 0.007331, 0.007753, 0.009588, 0.009817, 0.007939, 0.009055, 0.009648, 0.008966, 0.009384, 0.009508, 0.009138, 0.009164, 0.008493, 0.007730, 0.010912, 0.009618, 0.009127, 0.010203, 0.010929, 0.009120, 0.006329, 0.010727, 0.006932, 0.010171, 0.009600, 0.006165, 0.006111, 0.007100, 0.006057, 0.010450, 0.009240, 0.006123, 0.007575, 0.007643, 0.010453, 0.007129, 0.007972, 0.007764, 0.008701, 0.005544, 0.009506, 0.010204, 0.008971, 0.007061, 0.006224, 0.007131, 0.009627, 0.008959, 0.008481, 0.010705, 0.006480, 0.008029, 0.010293, 0.007480, 0.006980, 0.007943, 0.008114, 0.007646, 0.008544, 0.009582, 0.009541, 0.009695, 0.010246, 0.006999, 0.007107, 0.009463, 0.005296, 0.011960, 0.012810, 0.009657, 0.008489, 0.008556, 0.008389, 0.008062, 0.009453, 0.006611, 0.009561, 0.009414, 0.006247, 0.006451, 0.010089, 
                       0.008513, 0.009579, 0.008587, 0.008498, 0.008644, 0.009950, 0.008115, 0.008917, 0.008623, 0.010544, 0.010190, 0.008533, 0.009432, 0.009081, 0.008438, 0.007727, 0.007413, 0.007926, 0.009055, 0.009538, 0.008403, 0.008490, 0.007537, 0.006501, 0.007938, 0.008149, 0.009562, 0.009104, 0.010025, 0.007181, 0.008020, 0.008468, 0.009057, 0.006891, 0.007339, 0.010828, 0.008339, 0.008119, 0.007629, 0.008529, 0.007509, 0.006557, 0.007494, 0.007111, 0.006582, 0.008606, 0.009626, 0.007110, 0.006906, 0.009124, 0.007852, 0.007049, 0.007128, 0.009632, 0.007479, 0.007954, 0.007339, 0.008772, 0.009675, 0.009016, 0.010262, 0.009131, 0.008553, 0.008585, 0.008453, 0.007738, 0.008156, 0.007528, 0.008762, 0.008536, 0.008697, 0.007189, 0.009839, 0.004407, 0.009079, 0.006665, 0.009546, 0.012097, 0.010623, 0.006866, 0.006411, 0.007885, 0.008421, 0.008351, 0.007088, 0.008527, 0.007034, 0.008506, 0.007280, 0.006042, 0.006009, 0.006681, 0.005515, 0.009547, 0.010439, 0.007714, 0.009758, 0.006114, 0.006102, 0.005469, 0.007544, 0.007553, 0.006064, 0.006713, 0.006876, 0.006775, 0.007116, 0.006212, 0.005934, 0.006597, 0.007384, 0.009339, 0.008272, 0.009412, 0.008528, 0.007040, 0.009318, 0.006391, 0.009706, 0.009852, 0.006105, 0.006657, 0.008449, 0.005733, 0.007303, 0.007605, 0.009858, 0.008600, 0.008208, 0.009476, 0.008424, 0.008403, 0.009038, 0.008523, 0.009557, 0.007789, 0.007619, 0.004402, 0.007939, 0.009596, 0.006779, 0.006680, 0.006495, 0.007108, 0.007152, 0.009598, 0.009696, 0.010722, 0.011466, 0.008136, 0.008107, 0.006000, 0.007504, 0.009683, 0.008532, 0.009592, 0.006450, 0.009349, 0.009430, 0.009367, 0.011498, 0.019331, 0.009410, 0.009999, 0.007527, 0.007620, 0.005468, 0.007436, 0.011649, 0.011245, 0.006396, 0.010674, 0.010872, 0.007024, 0.006913, 0.010512, 0.006103, 0.010813, 0.006360, 0.005478, 0.007690, 0.008401, 0.010589, 0.010642, 0.010110, 0.007427, 0.007427, 0.008050, 0.007102, 0.006479, 0.007194, 0.007422, 0.007391, 0.011006, 0.010654, 0.010663, 0.008422, 0.010962, 0.010386, 0.010372, 0.005051, 0.023384, 0.014581, 0.008414, 0.007070, 0.007386, 0.010620, 0.010489, 0.010852, 0.011231, 0.007887, 0.007783, 0.010746, 0.010712, 0.008106, 0.010552, 0.009907, 0.009520, 0.009431, 0.006870, 0.006842, 0.008115, 0.008116, 0.009810, 
                       0.010516, 0.010670, 0.010818, 0.010206, 0.013477, 0.010776, 0.009672, 0.007304, 0.010684, 0.010799, 0.010348, 0.007351, 0.009217, 0.009855, 0.009726, 0.017230, 0.007311, 0.010885, 0.010604, 0.010329, 0.010618, 0.010796, 0.010256, 0.009617, 0.008151, 0.008061, 0.007964, 0.010591, 0.009624, 0.009902, 0.010461, 0.009511, 0.010695, 0.011563, 0.007141, 0.007314, 0.008826, 0.008826, 0.009669, 0.009362, 0.011080, 0.007995, 0.013134, 0.011913, 0.011167, 0.010083, 0.009520, 0.009689, 0.009589, 0.008252, 0.010697, 0.010903, 0.011125, 0.008532, 0.010222, 0.010369, 0.010019, 0.010297, 0.007553, 0.009338, 0.007653, 0.009187, 0.011432, 0.011615, 0.009054, 0.009610, 0.009584, 0.009288, 0.008424, 0.007595, 0.011251, 0.007444, 0.008453, 0.009169, 0.010199, 0.010784, 0.007219, 0.009447, 0.009704, 0.010269, 0.009777, 0.010744, 0.008748, 0.008839, 0.009450, 0.010593, 0.009559, 0.009394, 0.009672, 0.009551, 0.010734, 0.016434, 0.007263, 0.008584, 0.016154, 0.007600, 0.008269, 0.010866, 0.011471, 0.008852, 0.008903, 0.008502, 0.007669, 0.010688, 0.010676, 0.009432, 0.009658, 0.006388, 0.010806)
  
  IQRDNE.Whole <- c(0.017974, 0.019930, 0.022523, 0.026049, 0.023895, 0.022860, 0.024183, 0.022707, 0.024314, 0.023957, 0.020633, 0.022797, 0.021961, 0.017520, 0.023096, 0.027509, 0.021560, 0.019769, 0.025151, 0.021781, 0.018966, 0.024662, 0.022058, 0.019996, 0.015139, 0.025066, 0.025188, 0.020989, 0.020145, 0.012180, 0.024185, 0.023931, 0.027269, 0.023148, 0.023142, 0.023384, 0.024930, 0.027186, 0.024864, 0.022758, 0.022108, 0.020547, 0.025372, 0.023868, 0.029274, 0.021729, 0.025083, 0.018394, 0.019479, 0.021976, 0.022566, 0.021742, 0.027551, 0.024420, 0.019410, 0.016811, 0.017227, 0.025025, 0.018463, 0.016771, 0.013818, 0.013632, 0.013464, 0.016355, 0.016210, 0.022286, 0.022080, 0.022654, 0.015210, 0.024898, 0.023120, 0.025900, 0.023193, 0.020323, 0.020705, 0.024180, 0.016274, 0.025735, 0.020601, 0.018327, 0.028969, 0.023362, 0.027141, 0.022272, 0.024609, 0.020530, 0.025737, 0.026496, 0.027401, 0.021969, 0.023106, 0.021752, 0.017841, 
                    0.016979, 0.024936, 0.022765, 0.024016, 0.025102, 0.020031, 0.029704, 0.022962, 0.017351, 0.021108, 0.021724, 0.021677, 0.024294, 0.015210, 0.012732, 0.018501, 0.016317, 0.017841, 0.016954, 0.013705, 0.015738, 0.010664, 0.021487, 0.022509, 0.015995, 0.015099, 0.018459, 0.022752, 0.015824, 0.015293, 0.014521, 0.015104, 0.016091, 0.020354, 0.014163, 0.014948, 0.014105, 0.014993, 0.014174, 0.018163, 0.023194, 0.021548, 0.026002, 0.026002, 0.023661, 0.024617, 0.014019, 0.046371, 0.022027, 0.017440, 0.017225, 0.023887, 0.015962, 0.014155, 0.025306, 0.023785, 0.022621, 0.015815, 0.015181, 0.019431, 0.029469, 0.019454, 0.015212, 0.026101, 0.016954, 0.014032, 0.016934, 0.014514, 0.025011, 0.024280, 0.013501, 0.017350, 0.015886, 0.013983, 0.020880, 0.015682, 0.014798, 0.017107, 0.014638, 0.014982, 0.022067, 0.018262, 0.021389, 0.013950, 0.012703, 0.018309, 0.018208, 0.018159, 0.013834, 0.013894, 0.019270, 0.017212, 0.016112, 0.018213, 0.014935, 0.014128, 0.027333, 0.026569, 0.023728, 0.023690, 0.021527, 0.021585, 0.016734, 0.014660, 0.021405, 0.018810, 0.011898, 0.025077, 0.028777, 0.020766, 0.021693, 0.027485, 0.023424, 0.018434, 0.016931, 0.021542, 0.021753, 0.014495, 0.018245, 0.021693, 0.023154, 0.023179, 0.018695, 0.018302, 0.019345, 0.016153, 0.012629, 0.021848, 0.021805, 0.024861, 0.021852, 0.015138, 0.023003, 0.015865, 0.014207, 0.013059, 0.020791, 0.020042, 0.022509, 0.028485, 0.021708, 0.020163, 0.021846, 0.014839, 0.020585, 0.021885, 0.020554, 0.024423, 0.035190, 0.019425, 0.020475, 0.017512, 0.017372, 0.024597, 0.021087, 0.022694, 0.024300, 0.020344, 0.013113, 0.014172, 0.021037, 0.020118, 0.026042, 0.025193, 0.014949, 0.023141, 0.017581, 0.021539, 0.023655, 0.023280, 0.020340, 0.023190, 0.025992, 0.023125, 0.022938, 0.022913, 0.019176, 0.025938, 0.023060, 0.020150, 0.017520, 0.022543, 0.021752, 0.024197, 0.023163, 0.014076, 0.014885, 0.016712, 0.023345, 0.018857, 0.027000, 0.019469, 0.018357, 0.015387, 0.026979, 0.025099, 0.021434, 0.022059, 0.016557, 0.021024, 0.022813, 0.021739, 0.020775, 0.023089, 0.020304, 0.024667, 0.021096, 0.020174, 0.019513, 0.023812, 0.025935, 0.015467, 0.029584, 0.025074, 0.015206, 0.026735, 0.022137, 0.026630, 0.010311, 0.017972, 0.015261, 0.024901, 0.022164, 0.013179, 
                    0.010250, 0.019438, 0.024943, 0.017239, 0.023025, 0.021074, 0.021602, 0.015409, 0.020234, 0.027123, 0.018497, 0.017409, 0.012808, 0.034598, 0.015907, 0.018101, 0.020146, 0.025132, 0.016312, 0.017218, 0.028598, 0.016025, 0.013929, 0.019418, 0.019234, 0.016930, 0.021350, 0.014870, 0.021470, 0.024401, 0.021527, 0.014733, 0.016340, 0.019891, 0.014236, 0.021895, 0.024194, 0.022677, 0.021081, 0.021960, 0.017630, 0.017220, 0.015156, 0.015083, 0.021442, 0.019736, 0.015180, 0.015892, 0.023251, 0.021755, 0.022657, 0.019213, 0.024357, 0.020138, 0.025072, 0.017907, 0.018458, 0.015190, 0.025302, 0.021504, 0.021046, 0.019813, 0.023531, 0.026190, 0.019457, 0.019454, 0.019547, 0.018785, 0.019310, 0.019414, 0.020449, 0.017096, 0.015247, 0.015980, 0.023035, 0.021811, 0.021785, 0.021067, 0.018157, 0.016451, 0.021649, 0.021517, 0.013429, 0.014370, 0.018428, 0.021437, 0.020490, 0.020145, 0.020465, 0.018386, 0.015292, 0.018375, 0.015208, 0.020157, 0.020136, 0.021564, 0.015208, 0.013618, 0.025382, 0.019550, 0.022630, 0.014010, 0.023354, 0.014647, 0.017654, 0.019570, 0.021657, 0.023735, 0.025549, 0.017078, 0.022784, 0.015018, 0.022451, 0.019557, 0.018327, 0.018996, 0.017099, 0.016021, 0.017452, 0.017083, 0.016393, 0.021879, 0.015039, 0.017167, 0.015085, 0.021316, 0.023841, 0.022313, 0.012843, 0.014063, 0.019270, 0.018654, 0.016917, 0.017130, 0.021351, 0.013441, 0.019807, 0.019214, 0.013827, 0.012669, 0.016268, 0.011455, 0.021274, 0.023219, 0.015342, 0.017236, 0.012198, 0.014202, 0.016151, 0.020418, 0.018752, 0.012065, 0.015384, 0.014765, 0.014167, 0.015179, 0.013329, 0.015335, 0.013258, 0.018391, 0.020368, 0.024535, 0.018401, 0.016598, 0.016228, 0.026213, 0.015011, 0.021738, 0.022741, 0.013709, 0.014145, 0.019292, 0.016278, 0.016273, 0.022645, 0.021890, 0.018334, 0.014012, 0.020204, 0.027977, 0.021571, 0.019024, 0.014248, 0.023463, 0.018315, 0.018336, 0.018011, 0.016002, 0.018238, 0.017243, 0.011793, 0.013101, 0.014596, 0.015258, 0.024487, 0.018605, 0.016171, 0.023509, 0.021437, 0.021286, 0.018229, 0.017093, 0.024256, 0.024591, 0.021099, 0.016023, 0.011449, 0.019702, 0.018464, 0.027320, 0.036927, 0.027522, 0.028108, 0.016208, 
                    0.017345, 0.016982, 0.016903, 0.025346, 0.022879, 0.022851, 0.023732, 0.027948, 0.018366, 0.023429, 0.016483, 0.015466, 0.030053, 0.013787, 0.013958, 0.016090, 0.018247, 0.021550, 0.022976, 0.020904, 0.015909, 0.015909, 0.018422, 0.020162, 0.016216, 0.012369, 0.015906, 0.015857, 0.022383, 0.024176, 0.023723, 0.024610, 0.023128, 0.025843, 0.027628, 0.015686, 0.048682, 0.033769, 0.018646, 0.016344, 0.015268, 0.022383, 0.019000, 0.028853, 0.023943, 0.016943, 0.018500, 0.027107, 0.026455, 0.022810, 0.021121, 0.028755, 0.021002, 0.019988, 0.013990, 0.019077, 0.019252, 0.019249, 0.019263, 0.021646, 0.027219, 0.026199, 0.036664, 0.025018, 0.023669, 0.023773, 0.017231, 0.023758, 0.025444, 0.026044, 0.017037, 0.027319, 0.021357, 0.025483, 0.030707, 0.017295, 0.028791, 0.028231, 0.022932, 0.024398, 0.017719, 0.020506, 0.024196, 0.021737, 0.015913, 0.016858, 0.027207, 0.022835, 0.020974, 0.021290, 0.020255, 0.023875, 0.025919, 0.018375, 0.018445, 0.023176, 0.021759, 0.025256, 0.016949, 0.024556, 0.021655, 0.039027, 0.021674, 0.024073, 0.022774, 0.020999, 0.023660, 0.016223, 0.018996, 0.023280, 0.029709, 0.022349, 0.020069, 0.022677, 0.026302, 0.023887, 0.025055, 0.021330, 0.020783, 0.021652, 0.016174, 0.028873, 0.025935, 0.021026, 0.022039, 0.026620, 0.026113, 0.017240, 0.019348, 0.024892, 0.018297, 0.020063, 0.021746, 0.023324, 0.025675, 0.022440, 0.026884, 0.024022, 0.023682, 0.029912, 0.027453, 0.025043, 0.025543, 0.027556, 0.022314, 0.020865, 0.019516, 0.024038, 0.019442, 0.025896, 0.033855, 0.017350, 0.016224, 0.040627, 0.016089, 0.020148, 0.018438, 0.022109, 0.019059, 0.022052, 0.020194, 0.018217, 0.024746, 0.024292, 0.019413, 0.018667, 0.017106, 0.021931)
  
  MeanDNE.Convex <- c(0.017413, 0.025741, 0.021645, 0.021148, 0.021916, 0.025599, 0.024915, 0.024974, 0.021924, 0.021055, 0.024014, 0.022859, 0.024844, 0.025882, 0.021975, 0.029236, 0.020025, 0.023559, 0.022483, 0.023842, 0.024375, 0.022185, 0.024973, 0.022394, 0.018455, 0.023724, 0.026323, 0.018649, 0.020145, 0.016234, 0.021435, 0.022820, 0.027621, 0.027370, 0.021827, 0.018581, 0.021812, 0.020043, 0.023718, 0.018382, 0.022840, 0.024576, 
                      0.021797, 0.023734, 0.021855, 0.023074, 0.022123, 0.020297, 0.022781, 0.022665, 0.021586, 0.020626, 0.023096, 0.023958, 0.018101, 0.020596, 0.021841, 0.021851, 0.015298, 0.020130, 0.017086, 0.017601, 0.016341, 0.014708, 0.019595, 0.026373, 0.022682, 0.021623, 0.021774, 0.023961, 0.024250, 0.021363, 0.022550, 0.022656, 0.022651, 0.023511, 0.019909, 0.021383, 0.022733, 0.020662, 0.024218, 0.023184, 0.022755, 0.021608, 0.019998, 0.019051, 0.020412, 0.021813, 0.024074, 0.024077, 0.020976, 0.020698, 0.022765, 0.022228, 0.022945, 0.023623, 0.021611, 0.022737, 0.022542, 0.026271, 0.022395, 0.019763, 0.023695, 0.022720, 0.024665, 0.020828, 0.018159, 0.018334, 0.025049, 0.019576, 0.020138, 0.017900, 0.017248, 0.017235, 0.020517, 0.020165, 0.020760, 0.016391, 0.018576, 0.019222, 0.022158, 0.017288, 0.020175, 0.019240, 0.019674, 0.019626, 0.020466, 0.019329, 0.017351, 0.017376, 0.014684, 0.018642, 0.017436, 0.021768, 0.018927, 0.021480, 0.021480, 0.017839, 0.019728, 0.018782, 0.033688, 0.022585, 0.020189, 0.017957, 0.021631, 0.016383, 0.015695, 0.021901, 0.022742, 0.022688, 0.020447, 0.020553, 0.022634, 0.022162, 0.017323, 0.018506, 0.024723, 0.024590, 0.019775, 0.021823, 0.017602, 0.021958, 0.020234, 0.019641, 0.018224, 0.018709, 0.021738, 0.019775, 0.019280, 0.017235, 0.017205, 0.017235, 0.020256, 0.023947, 0.018720, 0.018456, 0.020775, 0.018326, 0.019635, 0.020682, 0.019696, 0.017244, 0.017232, 0.019281, 0.017704, 0.019546, 0.020438, 0.018418, 0.016017, 0.020778, 0.021280, 0.021290, 0.023225, 0.020489, 0.021169, 0.020658, 0.022293, 0.021727, 0.021031, 0.016453, 0.020017, 0.022808, 0.024602, 0.020765, 0.024018, 0.021870, 0.017849, 0.020765, 0.021280, 0.022406, 0.018959, 0.021478, 0.020765, 0.018808, 0.021556, 0.020719, 0.019627, 0.022505, 0.020228, 0.018545, 0.024001, 0.023350, 0.019662, 0.022849, 0.020817, 0.022851, 0.018083, 0.018235, 0.016260, 0.022776, 0.021541, 0.018403, 0.021391, 0.021378, 0.019671, 0.018733, 0.018878, 0.021939, 0.025196, 0.023567, 0.021706, 0.028214, 0.020003, 0.021521, 0.019878, 0.017134, 0.022686, 0.022489, 0.022819, 0.023889, 0.020355, 0.016982, 0.018458, 0.021677, 0.018153, 0.021206, 
                      0.025770, 0.015976, 0.021741, 0.022339, 0.019440, 0.023503, 0.020250, 0.019175, 0.023854, 0.021578, 0.018264, 0.021865, 0.022419, 0.021707, 0.021319, 0.026882, 0.019224, 0.021648, 0.021864, 0.023937, 0.022743, 0.022444, 0.018163, 0.018285, 0.021898, 0.022489, 0.022792, 0.023025, 0.021755, 0.020363, 0.021815, 0.022012, 0.023929, 0.018508, 0.021617, 0.024906, 0.022655, 0.021638, 0.021597, 0.020025, 0.021382, 0.021625, 0.021840, 0.025457, 0.021645, 0.021381, 0.021407, 0.022844, 0.022750, 0.023507, 0.021595, 0.020499, 0.021732, 0.018503, 0.017386, 0.017958, 0.021392, 0.017874, 0.024254, 0.021994, 0.018794, 0.018939, 0.019100, 0.022983, 0.019520, 0.021573, 0.017157, 0.019068, 0.021550, 0.024194, 0.022488, 0.022663, 0.019153, 0.018218, 0.023003, 0.021575, 0.022219, 0.021453, 0.021803, 0.016667, 0.018217, 0.022206, 0.019596, 0.017695, 0.018719, 0.018998, 0.020192, 0.021544, 0.023790, 0.025003, 0.021859, 0.020455, 0.018210, 0.020291, 0.024893, 0.018222, 0.024440, 0.022009, 0.020509, 0.021620, 0.021651, 0.023750, 0.021922, 0.018055, 0.018258, 0.025571, 0.020093, 0.018508, 0.018317, 0.019345, 0.023111, 0.019655, 0.021588, 0.021916, 0.021704, 0.021842, 0.022711, 0.020420, 0.020148, 0.017307, 0.025293, 0.021491, 0.023731, 0.021716, 0.020355, 0.020348, 0.018975, 0.019009, 0.023597, 0.021461, 0.021704, 0.021445, 0.019529, 0.020580, 0.020155, 0.020354, 0.021607, 0.021323, 0.025969, 0.020141, 0.019441, 0.021765, 0.021686, 0.016812, 0.017555, 0.022830, 0.020176, 0.020344, 0.021675, 0.023593, 0.019673, 0.018337, 0.019663, 0.019449, 0.022750, 0.018491, 0.021612, 0.016671, 0.017880, 0.022567, 0.021020, 0.017085, 0.017361, 0.019118, 0.016947, 0.020245, 0.021374, 0.022051, 0.021754, 0.019711, 0.020478, 0.021243, 0.019108, 0.018870, 0.016350, 0.017653, 0.020359, 0.019601, 0.018536, 0.022812, 0.021952, 0.022734, 0.020773, 0.018920, 0.022414, 0.018570, 0.021791, 0.022954, 0.021649, 0.015780, 0.018428, 0.021568, 0.022946, 0.021682, 0.023332, 0.022776, 0.017012, 0.023079, 0.021596, 0.018690, 0.016499, 0.017069, 0.018347, 0.022161, 0.022833, 0.019761, 0.017947, 0.017250, 0.017233, 0.015056, 0.019467, 0.019544, 0.015337, 0.017211, 0.018216, 0.018411, 0.020361, 0.017481, 0.018381, 0.016811, 0.018139, 0.021756, 0.016182, 0.018797, 
                      0.020587, 0.018037, 0.025058, 0.018369, 0.021709, 0.023847, 0.020505, 0.017457, 0.019538, 0.019568, 0.019640, 0.021664, 0.022609, 0.019338, 0.020253, 0.024328, 0.022588, 0.024183, 0.024359, 0.021840, 0.022731, 0.019668, 0.019594, 0.021447, 0.019705, 0.021655, 0.017198, 0.016944, 0.020170, 0.019360, 0.016479, 0.020820, 0.021719, 0.021619, 0.023929, 0.021705, 0.019791, 0.018073, 0.019369, 0.019357, 0.021875, 0.021637, 0.019510, 0.018241, 0.024077, 0.024026, 0.025283, 0.030237, 0.021895, 0.023982, 0.019643, 0.019627, 0.018511, 0.018209, 0.024930, 0.024913, 0.024740, 0.027564, 0.024106, 0.019199, 0.024504, 0.018399, 0.017338, 0.026291, 0.017314, 0.017198, 0.021739, 0.019908, 0.025797, 0.019203, 0.023617, 0.018432, 0.018432, 0.019252, 0.018037, 0.017239, 0.019470, 0.018506, 0.018347, 0.024492, 0.023027, 0.023194, 0.019318, 0.023905, 0.020745, 0.023831, 0.020170, 0.022844, 0.020491, 0.022129, 0.018282, 0.018368, 0.021732, 0.022664, 0.023107, 0.023843, 0.023241, 0.018126, 0.022888, 0.023687, 0.026933, 0.021733, 0.024491, 0.025996, 0.021650, 0.019738, 0.020419, 0.020337, 0.021562, 0.021538, 0.021921, 0.026113, 0.020693, 0.023510, 0.028159, 0.021809, 0.021751, 0.018089, 0.022188, 0.020975, 0.026443, 0.021229, 0.022967, 0.025882, 0.021193, 0.026467, 0.018897, 0.024318, 0.027313, 0.025673, 0.021984, 0.023322, 0.026476, 0.021067, 
                      0.024455, 0.020025, 0.018224, 0.026576, 0.021718, 0.024491, 0.026271, 0.021158, 0.021926, 0.024362, 0.017486, 0.017941, 0.020267, 0.020267, 0.024327, 0.020551, 0.019704, 0.020443, 0.030251, 0.020886, 0.023890, 0.023946, 0.022758, 0.021841, 0.021648, 0.022589, 0.023739, 0.023436, 0.027416, 0.019346, 0.022220, 0.021753, 0.024532, 0.024388, 0.020975, 0.020545, 0.023380, 0.021542, 0.024897, 0.025089, 0.024124, 0.021698, 0.023040, 0.024389, 0.017625, 0.019092, 0.021023, 0.021621, 0.024186, 0.017120, 0.022697, 0.020813, 0.021962, 0.020927, 0.019615, 0.020833, 0.024291, 0.027211, 0.021840, 0.019685, 0.022916, 0.021808, 0.025086, 0.023930, 0.019242, 0.023977, 0.022265, 0.029323, 0.019370, 0.019229, 0.027291, 0.021783, 0.019933, 0.023686, 0.024117, 0.024297, 0.021065, 0.021515, 0.021537, 0.020709, 0.020237, 0.023681, 0.021855, 0.018345, 0.024964)
  
  PCLR_Train<-data.frame(Age, Cluster1, MeanDNE.Apex, TotalDNE.TotalPolygonFaces, MedianDNE.Whole, IQRDNE.Whole, MeanDNE.Convex)
  PCLR_Train
}

#' @examples 
#' PCLR_Train