% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KMunicate.R
\name{KMunicate}
\alias{KMunicate}
\title{Create KMunicate-Style Kaplan–Meier Plots}
\usage{
KMunicate(
  fit,
  time_scale,
  .risk_table = "KMunicate",
  .reverse = FALSE,
  .theme = NULL,
  .color_scale = NULL,
  .fill_scale = NULL,
  .linetype_scale = NULL,
  .annotate = NULL,
  .xlab = "Time",
  .ylab = ifelse(.reverse, "Estimated (1 - survival)", "Estimated survival"),
  .title = NULL,
  .alpha = 0.25,
  .rel_heights = NULL,
  .ff = NULL,
  .risk_table_base_size = 11,
  .size = NULL,
  .legend_position = c(1, 1)
)
}
\arguments{
\item{fit}{A \code{survfit} object.}

\item{time_scale}{The time scale that will be used for the x-axis and for the summary tables.}

\item{.risk_table}{This arguments define the type of risk table that is produced.}

\item{.reverse}{If \code{reverse = TRUE}, then the plot uses 1 - survival probability on the y-axis.
Defaults to \code{KMunicate}, where the cumulative number of events and censored are calculated.
Another possibility is \code{survfit}, which will use the default numbers returned by \code{summary.survfit} (e.g. number of events and censored per interval).
\code{.risk_table} can also be \code{NULL}, in which case the risk table will be omitted from the plot.}

\item{.theme}{\code{ggplot} theme used by the plot. Defaults to \code{NULL}, where the default \code{ggplot} theme will be used.}

\item{.color_scale}{Colour scale used for the plot. Has to be a \verb{scale_colour_*} component, and defaults to \code{NULL} where the default colour scale will be used.}

\item{.fill_scale}{Fill scale used for the plot. Has to be a \verb{scale_fill_*} component, and defaults to \code{NULL} where the default fill scale will be used.}

\item{.linetype_scale}{Linetype scale used for the plot. Has to be a \verb{scale_linetype_*} component, and defaults to \code{NULL} where the default linetype scale will be used.}

\item{.annotate}{Optional annotation to be added to the plot, e.g. using \code{\link[ggplot2:annotate]{ggplot2::annotate()}}. Defaults to \code{NULL}, where no extra annotation is added.}

\item{.xlab}{Label for the horizontal axis, defaults to \emph{Time}.}

\item{.ylab}{Label for the vertical axis, defaults to \emph{Estimated survival} if \code{.reverse = FALSE}, to \emph{Estimated (1 - survival)} otherwise.}

\item{.title}{A title to be added on top of the plot. Defaults to \code{NULL}, where no title will be included.}

\item{.alpha}{Transparency of the point-wise confidence intervals}

\item{.rel_heights}{Override default relative heights of plots and tables. Must be a numeric vector of length equal 1 + 1 per each arm in the Kaplan-Meier plot. See \code{\link[cowplot:plot_grid]{cowplot::plot_grid()}} for more details on how to use this argument.}

\item{.ff}{A string used to define a base font for the plot.}

\item{.risk_table_base_size}{Base font size for the risk table, given in pts. Defaults to 11.}

\item{.size}{Thickness of each Kaplan-Meier curve. Defaults to \code{NULL}, where \code{ggplot2}'s default will be used.}

\item{.legend_position}{Position of the legend in the plot. Defaults to \code{c(1, 1)}, which corresponds to \emph{top-right} of the plot. It is also possible to pass a string, as in \code{ggplot2}, e.g. \code{"none"} to suppress the legend. N.B.: Legend justification is modified accordingly. See \code{\link[ggplot2:theme]{ggplot2::theme()}} for more details on how to place the legend of the plot.}
}
\value{
A KMunicate-style \code{ggplot} object.
}
\description{
Produce Kaplan–Meier plots in the style recommended following the KMunicate study by TP Morris \emph{et al}. (\doi{10.1136/bmjopen-2019-030215}).
}
\examples{
library(survival)
data("cancer2", package = "KMunicate")
KM <- survfit(Surv(studytime, died) ~ drug, data = cancer2)
time_scale <- seq(0, max(cancer2$studytime), by = 7)
KMunicate(fit = KM, time_scale = time_scale)
}
