% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimu.R
\name{SimuBlocksInv}
\alias{SimuBlocksInv}
\title{Simulate Blocks Data}
\usage{
SimuBlocksInv(n, sigma, seed = NA, tau, h)
}
\arguments{
\item{n}{Number of data points}

\item{sigma}{Standard deviation of the noise added to the signal}

\item{seed}{An optional seed for random number generation to make results reproducible}

\item{tau}{The locations of change points in the underlying trend}

\item{h}{The constant values of the \eqn{length(tau)+1} segments of the underlying trend}
}
\value{
A list containing the piecewise constant simulated data and the underlying trend:
\item{x}{The set \{ \eqn{\frac{1}{n}}, \eqn{\frac{2}{n}}, \eqn{\frac{3}{n}},\dots, \eqn{1}\}}
\item{y}{The piecewise constant simulated data of length \eqn{n}}
\item{y0}{The underlying trend of length \eqn{n}}
\item{setA}{The set of position indicators of change points in the simulated data}
\item{tau}{The locations of change points in the underlying trend}
}
\description{
This function generates data points of piecewise constant trends.
}
\details{
\itemize{
\item{To simplify the analysis, normalize the change point positions to a range between 0 and 1. Require that all elements of the input \eqn{tau} are within this range. Consequently, the change point positions in simulated data forms a subset of the set \{ \eqn{\frac{1}{n}}, \eqn{\frac{2}{n}}, \eqn{\frac{3}{n}},\dots, 1\}.}
\item{In fact, \eqn{length(tau)} change points can divide the interval into \eqn{length(tau)+1} segments of constant function values. Therefore, ensure that the length of vector \eqn{h} is \eqn{length(tau)+1}.}
}
}
\examples{
tau = c(0.1, 0.3, 0.4, 0.7, 0.85)
h = c(-1, 5, 3, 0, -1, 2)
BlocksData <- SimuBlocksInv(n = 350, sigma = 0.1, seed = 50, tau = tau ,h = h)
plot(BlocksData$x, BlocksData$y, xlab="", ylab="")
lines(BlocksData$x, BlocksData$y0, col = "red")
print(BlocksData$setA)
print(BlocksData$tau)
}
