% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RD_for_LA_LHD.R
\name{LA_LHDC}
\alias{LA_LHDC}
\alias{permuC}
\alias{seqC}
\alias{rLHDC}
\alias{dijC}
\alias{phi_pC}
\alias{MaxProCriterionC}
\alias{corC}
\alias{MaxAbsCorC}
\alias{AvgAbsCorC}
\alias{exchangeC}
\title{Lioness Algorithm for Latin hypercube design}
\usage{
LA_LHDC(n, k, m = 100L, N = 5000L, OC = "phi_p", p = 15L, q = 1L)

permuC(x)

seqC(a, b)

rLHDC(n, k)

dijC(X, i, j, q = 1L)

phi_pC(X, p = 15L, q = 1L)

MaxProCriterionC(X)

corC(x, y)

MaxAbsCorC(X)

AvgAbsCorC(X)

exchangeC(X, j, type = "col")
}
\arguments{
\item{n}{A positive integer that stands for the number of rows (or run size).}

\item{k}{A positive integer that stands for the number of columns (or factor size).}

\item{m}{A positive integer that stands for the number of starting design candidates. The default is set to be 100.}

\item{N}{A positive integer that stands for the maximum number of iterations. The default is set to be 5000. A larger value of \code{N} may result a high CPU time.}

\item{OC}{An optimality criterion. The default setting is "phi_p" (for space-filling LHDs), and it could be one of the following: "phi_p", "AvgAbsCor", "MaxAbsCor", "MaxProCriterion".}

\item{p}{A positive integer that is the parameter in the phi_p formula, and \code{p} is preferred to be large. The default and recommended value is 15.}

\item{q}{The default is set to be 1, and it could be either 1 or 2. If \code{q} is 1, the Manhattan (rectangular) distance will be used. If \code{q} is 2, the Euclidean distance will be used.}

\item{x}{A vector.}

\item{a}{is the starting value of the sequence.}

\item{b}{is the ending value of the sequence.}

\item{X}{A matrix object. In general, \code{X} stands for a design matrix.}

\item{i}{A positive integer, which stands for the ith row of \code{X}.}

\item{j}{A positive integer, which stands for the jth column (or row) of \code{X}, and it should be within [1,ncol(X)] (or [1,nrow(X)]).}

\item{y}{A vector.}

\item{type}{An exchange type. If \code{type} is "col" (the default setting), two random elements will be exchanged within column \code{j}. If \code{type} is "row", two random elements will be exchanged within row \code{j}.}
}
\value{
If all inputs are logical, then the output will be an optimal \code{n} by \code{k} LHD.
}
\description{
\code{LA_LHDC} returns an optimal \code{n} by \code{k} Latin hypercube design (LHD) matrix generated by lioness algorithm (LA)
}
\examples{
#generate a 6 by 3 maximin distance LHD with the default setting
try=LA_LHDC(n=6,k=3)
try

#Another example
#generate a 9 by 4 nearly orthogonal LHD
try2=LA_LHDC(n=9,k=4,OC="AvgAbsCor")
try2

}
