% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\title{Fit the pre-defined Neural Network for Longitudinal Data}
\usage{
fit_model(
  model,
  ver,
  n_epoch,
  bsize,
  X1,
  X2,
  X3,
  X4,
  X5,
  X6,
  X7,
  X8,
  X9,
  X10,
  Xif,
  y
)
}
\arguments{
\item{model}{The model object produced by create_model().}

\item{ver}{ver=0 to show nothing, ver=1 to show animated progress bar, ver=2 to just mention the number of epoch during training.}

\item{n_epoch}{The number of epochs to train the model.}

\item{bsize}{The batch size.}

\item{X1}{Features as inputs of 1st LSTM.}

\item{X2}{Features as inputs of 2nd LSTM.}

\item{X3}{Features as inputs of 3rd LSTM.}

\item{X4}{Features as inputs of 4th LSTM.}

\item{X5}{Features as inputs of 5th LSTM.}

\item{X6}{Features as inputs of 6th LSTM.}

\item{X7}{Features as inputs of 7th LSTM.}

\item{X8}{Features as inputs of 8th LSTM.}

\item{X9}{Features as inputs of 9th LSTM.}

\item{X10}{Features as inputs of 10th LSTM.}

\item{Xif}{The features to be concatenated with the outputs of the LSTMs.}

\item{y}{The target variable.}
}
\value{
The fitted model.
}
\description{
Fit the created Neural Network model (Keras).
}
\examples{
X1 <- matrix(runif(500*20), nrow=500, ncol=20)
X2 <- matrix(runif(500*24), nrow=500, ncol=24)
X3 <- matrix(runif(500*24), nrow=500, ncol=24)
X4 <- matrix(runif(500*24), nrow=500, ncol=24)
X5 <- matrix(runif(500*16), nrow=500, ncol=16)
X6 <- matrix(runif(500*16), nrow=500, ncol=16)
X7 <- matrix(runif(500*16), nrow=500, ncol=16)
X8 <- matrix(runif(500*16), nrow=500, ncol=16)
X9 <- matrix(runif(500*16), nrow=500, ncol=16)
X10 <- matrix(runif(500*15), nrow=500, ncol=15)
Xif <- matrix(runif(500*232), nrow=500, ncol=232)
y <- matrix(runif(500), nrow=500, ncol=1)
\dontrun{
fitted_model = fit_model(model,0,1,32,X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,Xif,y)
}
# The functions require to have python installed
# As well as tensorflow, keras and reticulate package.
}
