% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/12_HETEROGENEITY.R
\name{heterogeneity}
\alias{heterogeneity}
\title{Testing heterogeneity of the LGD rating model}
\usage{
heterogeneity(app.port, loss, pools, method = "t.test", alpha = 0.05)
}
\arguments{
\item{app.port}{Application portfolio (data frame) which contains realized loss (LGD) values and
LGD pools in use.}

\item{loss}{Name of the column that represents realized loss (LGD).}

\item{pools}{Name of the column that represents LGD pools.}

\item{method}{Statistical test. Available options are \code{t.test} (default) and \code{wilcox.test}.}

\item{alpha}{Significance level of statistical test. Default is 0.05.}
}
\value{
The command \code{heterogeneity} returns a data frame with the following columns:
\itemize{
\item pool: Unique values of pool from application portfolio.
\item no: Number of complete observations.
\item mean: Average realized loss.
\item alpha: Selected significance level
\item p.val: Test p-value.
\item res: Accepted hypothesis.
}
}
\description{
\code{heterogeneity} performs heterogeneity testing of LGD model based on the rating pools.
This test is usually applied on application portfolio, but it can be applied also on model development sample.
}
\details{
Testing procedure starts with summarizing the number of observations and average loss per LGD pool.
After that statistical test is applied on adjacent rating grades. Testing hypothesis is that
average realized loss of pool \code{i} is less or greater than average realized loss of pools \code{i - 1}, where \code{i}
takes the values from 2 to the number of unique pools.
Direction of alternative hypothesis (less or greater) is determined automatically based on correlation direction
of realized average loss per pool.
Incomplete cases, identified based on realized loss (\code{loss}) and rating pool (\code{pools})
columns are excluded from the summary table and testing procedure. If identified, warning will be returned.
}
\examples{
library(monobin)
library(LGDtoolkit)
data(lgd.ds.c)
#build dummy model
rf <- c("rf_02", "rf_01", "rf_16", "rf_03", "rf_09")
for   (i in 1:length(rf)) {
     rf_l <- rf[i]
     lgd.ds.c[, rf_l] <- sts.bin(x = lgd.ds.c[, rf_l], 
                                 y = lgd.ds.c[, "lgd"])[[2]]	
     }
str(lgd.ds.c)
frm <- paste0("lgd ~ ", paste(rf, collapse = " + "))
model <- lm(formula = as.formula(frm), data = lgd.ds.c)
summary(model)$coefficients
summary(model)$r.squared
#create lgd pools
lgd.ds.c$pred <- unname(predict(model))
lgd.ds.c$pool <- sts.bin(x = lgd.ds.c$pred, 
                        y = lgd.ds.c$lgd)[[2]]
#create dummy application portfolio
set.seed(642)
app.port <- lgd.ds.c[sample(1:nrow(lgd.ds.c), 500, replace = FALSE), ]
#simulate realized lgd values
app.port$lgd.r <- app.port$lgd
#test heterogeneity
heterogeneity(app.port = app.port, 
	  loss = "lgd.r", 
	  pools = "pool", 
             method = "t.test", 
             alpha = 0.05) 
}
