% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_doc_summarizer_agent.R
\name{build_doc_summarizer_agent}
\alias{build_doc_summarizer_agent}
\title{Build a Document Summarizer Agent}
\usage{
build_doc_summarizer_agent(
  llm,
  summary_template = NULL,
  chunk_size = 4000,
  overlap = 200,
  verbose = TRUE
)
}
\arguments{
\item{llm}{A function that accepts a character prompt and returns an LLM response.}

\item{summary_template}{Optional custom summary template in markdown format.}

\item{chunk_size}{Maximum character length for document chunks (default: 4000).}

\item{overlap}{Character overlap between chunks (default: 200).}

\item{verbose}{Logical controlling progress messages (default: TRUE).}
}
\value{
A function that accepts file paths or text input and returns:
\itemize{
  \item summary - The generated markdown summary
  \item metadata - Document metadata if available
  \item chunks - Number of processing chunks used
  \item success - Logical indicating success
}
}
\description{
Creates an LLM-powered document summarization workflow that processes PDF, DOCX,
PPTX, TXT, or plain text input and returns structured markdown summaries.
}
\examples{
\dontrun{
# Build document summarizer agent
summarizer_agent <- build_doc_summarizer_agent(
  llm = my_llm_wrapper,
  summary_template = NULL,
  chunk_size = 4000,
  overlap = 200,
  verbose = FALSE
)

# Summarize document
final_state <- summarizer_agent("https://github.com/knowusuboaky/LLMAgentR/raw/main/\
tests/testthat/test-data/scrum.docx")
}
}
