% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_whittle_loglik_theta.R
\name{LS.whittle.loglik.theta}
\alias{LS.whittle.loglik.theta}
\title{Locally Stationary Whittle Log-likelihood theta}
\usage{
LS.whittle.loglik.theta(
  x,
  series,
  order = c(p = 0, q = 0),
  ar.order = NULL,
  ma.order = NULL,
  sd.order = NULL,
  d.order = NULL,
  include.d = FALSE,
  N = NULL,
  S = NULL,
  include.taper = TRUE,
  sd.par = 1
)
}
\arguments{
\item{x}{(type: numeric) parameter vector.}

\item{series}{(type: numeric) univariate time series.}

\item{order}{(type: numeric) vector corresponding to \code{ARMA} model
entered.}

\item{ar.order}{(type: numeric) AR polimonial order.}

\item{ma.order}{(type: numeric) MA polimonial order.}

\item{sd.order}{(type: numeric) polinomial order noise scale factor.}

\item{d.order}{(type: numeric) \code{d} polinomial order, where \code{d} is
the \code{ARFIMA} parameter.}

\item{include.d}{(type: numeric) logical argument for \code{ARFIMA} models.
If \code{include.d=FALSE} then the model is an ARMA process.}

\item{N}{(type: numeric) value corresponding to the length of the window to
compute periodogram. If \code{N=NULL} then the function will use
\eqn{N = \textrm{trunc}(n^{0.8})}, see Dahlhaus (1998) where \eqn{n} is the
length of the \code{y} vector.}

\item{S}{(type: numeric) value corresponding to the lag with which will go
taking the blocks or windows.}

\item{include.taper}{(type: logical) logical argument that by default is
\code{TRUE}. See \code{\link{periodogram}}.}

\item{sd.par}{(type: numeric) value corresponding to known variance.}
}
\description{
Calculate the log-likelihood with \eqn{\sigma} known, through
\code{LS.whittle.loglik} function.
}
\details{
This function computes \code{\link{LS.whittle.loglik}} with \code{x} as
\code{x = c(x, sd.par)}.
}
