% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covariance_Matrix_Functions.R
\name{get_relatedness}
\alias{get_relatedness}
\title{Relatedness between a pair of family members}
\usage{
get_relatedness(s1, s2, h2 = 0.5, from_covmat = FALSE)
}
\arguments{
\item{s1, s2}{Strings representing the two family members.
The strings must be chosen from the following list of strings:
- \code{g} (Genetic component of full liability)
- \code{o} (Full liability)
- \code{m} (Mother)
- \code{f} (Father)
- \code{c[0-9]*.[0-9]*} (Children)
- \code{mgm} (Maternal grandmother)
- \code{mgf} (Maternal grandfather)
- \code{pgm} (Paternal grandmother)
- \code{pgf} (Paternal grandfather)
- \code{s[0-9]*} (Full siblings)
- \code{mhs[0-9]*} (Half-siblings - maternal side)
- \code{phs[0-9]*} (Half-siblings - paternal side)
- \code{mau[0-9]*} (Aunts/Uncles - maternal side)
- \code{pau[0-9]*} (Aunts/Uncles - paternal side).}

\item{h2}{A number representing the squared heritability on liability scale.
Must be non-negative and at most 1. Defaults to 0.5}

\item{from_covmat}{logical variable. Only used internally. allows for skip of negative check.}
}
\value{
If both \code{s1} and \code{s2} are strings chosen from the mentioned
list of strings and \code{h2} is a number satisfying \eqn{0 \leq h2 \leq 1},
then the output will be a number that equals the percentage of shared
DNA between \code{s1} and \code{s2} times the squared heritability \code{h2}.
}
\description{
\code{get_relatedness} returns the relatedness times the
liability-scale heritability for a pair of family members
}
\details{
This function can be used to get the percentage of shared
DNA times the liability-scale heritability \eqn{h^2} for two family members.
}
\note{
If you are only interested in the percentage of shared DNA, set \code{h2 = 1}.
}
\examples{
get_relatedness("g","o")
get_relatedness("g","f", h2 = 1)
get_relatedness("o","s", h2 = 0.3)


# This will result in errors:
try(get_relatedness("a","b"))
try(get_relatedness(m, mhs))

}
